
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.gridspec import GridSpec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# ========== Bar with Error Data (Student Performance in Subjects) ==========
# Subjects
subjects = ["Math", "Science", "History", "Art"]
# Average Scores
avg_scores = [78, 85, 72, 89]
# Error margins
errors = [3, 5, 4, 2]

# ========== Scatter with Error Data (Teacher Effectiveness) ==========
# Teachers
teachers = ["Teacher A", "Teacher B", "Teacher C", "Teacher D"]
# Effectiveness scores
effectiveness = np.random.uniform(70, 95, len(teachers))
# Standard deviations
std_devs = np.random.uniform(3, 6, len(teachers))

# ========== Line with Error Data (Student Improvement Over Terms) ==========
# Terms
terms = ["Term 1", "Term 2", "Term 3", "Term 4"]
# Improvement Scores
improvement_regular = np.random.uniform(70, 85, len(terms))
improvement_coaching = np.random.uniform(75, 90, len(terms))
# Error margins
error = np.random.uniform(1, 2, len(terms))

titles = [
    "Student Performance in Subjects",
    "Teacher Effectiveness Scores",
    "Student Improvement Over Terms",
]
ylabels = ["Average Score (%)", "Effectiveness (%)", "Improvement (%)"]
ax2ylim = [65, 100]
ax3labels = ["Regular Classes", "Extra Coaching"]
legend_title = "Classes"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and grid layout
fig = plt.figure(figsize=(12, 10))
gs = GridSpec(2, 2, figure=fig)

# Bar with Error Plot
ax1 = fig.add_subplot(gs[0, :])
ax1.bar(subjects, avg_scores, yerr=errors, color="#ff9999", capsize=5, ecolor="black")
ax1.set_title(titles[0])
ax1.set_ylabel(ylabels[0])
ax1.grid(True, linestyle='--', alpha=0.7)

# Scatter with Error Plot
ax2 = fig.add_subplot(gs[1, 0])
ax2.errorbar(
    teachers,
    effectiveness,
    yerr=std_devs,
    fmt="D",
    color="#66b3ff",
    ecolor="black",
    capsize=5,
    ms=10,
    linestyle='None'
)
ax2.set_title(titles[1])
ax2.set_ylabel(ylabels[1])
ax2.set_ylim(ax2ylim)
ax2.grid(True, linestyle='--', alpha=0.7)

# Line with Error Plot
ax3 = fig.add_subplot(gs[1, 1])
ax3.errorbar(
    terms,
    improvement_regular,
    yerr=error,
    fmt="o-",
    color="green",
    ecolor="black",
    capsize=5,
    label=ax3labels[0],
    linestyle='-.'
)
ax3.errorbar(
    terms,
    improvement_coaching,
    yerr=error,
    fmt="s-",
    color="blue",
    ecolor="black",
    capsize=5,
    label=ax3labels[1],
    linestyle='--'
)
ax3.set_title(titles[2])
ax3.set_ylabel(ylabels[2])
ax3.legend(title=legend_title)
ax3.grid(True, linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("multidiff_89.pdf", bbox_inches="tight")
