
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.gridspec import GridSpec
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Create a figure and a GridSpec layout
fig = plt.figure(figsize=(10, 5))
gs = GridSpec(1, 2, figure=fig)

# ------- Pie Chart Data for Law Specializations -------
categories = ["Criminal Law", "Civil Law", "Corporate Law", "Family Law", "Constitutional Law"]
sizes = [25, 30, 15, 20, 10]  # Percentages of each specialization

explode = (0.1, 0, 0, 0, 0)  # Highlight Criminal Law

# ------- Radar Chart Data for Law Student Performance Metrics -------
labels = np.array(
    ["Analytical Skills", "Legal Research", "Argumentation", "Ethical Reasoning", "Writing Skills"]
)
num_vars = len(labels)
values = np.array([0.85, 0.80, 0.90, 0.75, 0.88])
values = np.concatenate((values, [values[0]]))
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()
angles += angles[:1]

title_1 = "Distribution of Law Specializations"
title_2 = "Law Student Performance Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#264653", "#2a9d8f", "#e9c46a", "#f4a261", "#e76f51"]

# Create the pie chart in the left panel
ax1 = fig.add_subplot(gs[0, 0])
wedges, texts, autotexts = ax1.pie(
    sizes,
    labels=categories,
    colors=colors,
    autopct="%1.1f%%",
    startangle=140,
    explode=explode,
)
ax1.set_title(title_1)
ax1.axis("equal")  # Equal aspect ratio ensures that pie is drawn as a circle.

# Create the radar chart in the right panel
ax2 = fig.add_subplot(gs[0, 1], polar=True)
ax2.fill(angles, values, color="#2a9d8f", alpha=0.25)
ax2.plot(angles, values, color="#2a9d8f", linewidth=2, linestyle='dotted')
ax2.set_xticks(angles[:-1])
ax2.set_xticklabels(labels)
ax2.set_title(title_2)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("multidiff_95.pdf", bbox_inches="tight")
