
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data to plot
sizes = [20, 25, 15, 10, 18, 12]
labels = ["Stoicism", "Existentialism", "Utilitarianism", "Deontology", "Virtue Ethics", "Nihilism"]
title = "Influence of Philosophical Schools Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
explode = (0.1, 0.1, 0.1, 0.1, 0.1, 0.1)  # add explode parameter to separate slices
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]  # New color scheme for philosophical schools
# Plot
fig, ax = plt.subplots(figsize=(7, 7))
ax.pie(
    sizes,
    labels=labels,
    colors=colors,
    autopct="%1.1f%%",
    startangle=140,
    wedgeprops=dict(edgecolor="w"),
    explode=explode,
)

# Set title
plt.title(title, fontsize=16, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("pie_21.pdf", bbox_inches="tight")
