
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data to plot
sizes = [35.0, 30.0, 20.5, 5.0, 5.0, 4.5]  # Coal, Natural Gas, Nuclear, Hydroelectric, Solar, Wind respectively
labels = ["Coal", "Natural Gas", "Nuclear", "Hydroelectric", "Solar", "Wind"]

# Text labels
title = "Energy Consumption by Source"
percent_format = "%1.1f%%"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
explode = (0.1, 0.1, 0.1, 0.1, 0.1, 0.1)  # add explode parameter to separate slices
colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0", "#ffb3e6"]  # custom colors

# Configure plot
fig, ax = plt.subplots(figsize=(6, 6))
ax.pie(
    sizes,
    colors=colors,
    autopct=percent_format,
    startangle=140,
    wedgeprops=dict(edgecolor="w"),
    explode=explode,
    labels=labels,
)

# Add title
ax.set_title(title, pad=20, fontsize=16, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("pie_22.pdf", bbox_inches="tight")
