
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================

# Data to plot
sizes = [15, 25, 35, 10, 8, 7]
labels = ['0-18', '19-35', '36-50', '51-65', '66-80', '80+']
colors = ["#e41a1c", "#377eb8", "#4daf4a", "#984ea3", "#ff7f00", "#ffff33"]

title = "Population Distribution by Age Group"
legendlabels = labels

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
explode = (0.1, 0.1, 0.1, 0.1, 0.1, 0.1)  # add explode parameter to separate slices
# Plot
fig, ax = plt.subplots(figsize=(7, 7))
ax.pie(
    sizes,
    colors=colors,
    labels=labels,
    autopct="%1.1f%%",
    startangle=140,
    wedgeprops=dict(edgecolor="w"),
    explode=explode,
)

# Add title
plt.title(title, fontsize=16)

# Add legend
ax.legend(legendlabels, loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("pie_23.pdf", bbox_inches="tight")

