
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
# ===================
# Part 2: Data Preparation
# ===================
labels = ["Stocks", "Bonds", "Real Estate", "Commodities"]
sizes = [50, 20, 15, 15]
legend_labels = labels
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]  # Custom color palette

# Textual Content
title = "Investment Portfolio Distribution"
legend_title = "Categories"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(6, 6))
legend_loc = "upper center"
legend_ncol = 2
legend_frameon = True
legend_bbox_to_anchor = (0.5, 1.2)

# Plotting the pie chart
wedges, texts, autotexts = ax.pie(
    sizes, 
    autopct="%1.1f%%", 
    startangle=90, 
    colors=colors,
    shadow=True,
    pctdistance=0.85
)

# Customizing the text appearance
for text in texts + autotexts:
    text.set_fontsize(12)
    text.set_color("black")

# Adding legend
plt.legend(
    legend_labels,
    loc=legend_loc,
    ncol=legend_ncol,
    frameon=legend_frameon,
    title=legend_title,
    bbox_to_anchor=legend_bbox_to_anchor,
)

# Adding title
plt.title(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("pie_28.pdf", bbox_inches="tight")
