
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
labels = ["Ancient Egypt", "Ancient Greece", "Roman Empire", "Ancient China"]
sizes = [25, 20, 35, 20]
legend_labels = labels
title = "Contributions of Civilizations to World Heritage Sites"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(7, 7))  # Larger figure for better readability
legend_loc = "upper center"
legend_ncol = 2  # Fewer columns to fit better
legend_frameon = True  # Add frame to the legend
legend_bbox_to_anchor = (0.5, 1.)  # Position legend above chart
colors = ["#D4AF37", "#C0C0C0", "#CD7F32", "#8B4513"]  # Gold, Silver, Bronze, Earth

wedges, texts, autotexts = ax.pie(
    sizes, 
    autopct="%1.1f%%", 
    startangle=90, 
    colors=colors, 
    wedgeprops={"edgecolor": "black", "linewidth": 1.5}
)
plt.setp(autotexts, size=10, weight="bold")  # Customize the size of percentage labels

plt.legend(
    legend_labels,
    loc=legend_loc,
    ncol=legend_ncol,
    frameon=legend_frameon,
    bbox_to_anchor=legend_bbox_to_anchor,
)
plt.title(title, fontsize=16, weight='bold') # Adding title with larger, bold font

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("pie_29.pdf", bbox_inches="tight")
