
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for population distribution across different regions
labels = ["Northeast 17%", "Midwest 21%", "South 38%", "West 24%"]
sizes = [17, 21, 38, 24]

# Chart text parameters
title = "Population Distribution Across US Regions"
output_filename = "pie_4_2.pdf"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(6, 6))

# Custom color scheme
colors = ['#003f5c', '#58508d', '#bc5090', '#ff6361']

# Pie chart with updated styles
ax.pie(sizes, labels=labels, colors=colors, hatch=['*', 'o', '-', '.'], startangle=90)

plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("pie_31.pdf", bbox_inches="tight")
