
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data to plot
labels = ["Work", "Family", "Leisure", "Self-care", "Sleep"]
sizes = [40, 20, 15, 15, 10]

# Text Labels
title_text = "Distribution of Mental Energy Usage"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
plt.figure(figsize=(8, 6))
legend_labels = labels
# Define a color palette
colors = ['#FF9999', '#66B2FF', '#99FF99', '#FFCC99', '#FFD700']
explode = (0.1, 0, 0, 0, 0)  # explode the 1st slice "Work"

# Plot pie chart
plt.pie(
    sizes,
    explode=explode,
    colors=colors,
    autopct="%1.1f%%",
    shadow=True,
    startangle=140,
    wedgeprops={"edgecolor": "black"}
)
plt.axis("equal")  # Ensure the pie is drawn as a circle

# Add legend
plt.legend(legend_labels, loc="upper left")
plt.title(title_text, fontsize=16, y=1.05)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("pie_40.pdf", bbox_inches="tight")
