
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
# Data to plot
labels = ["Asia", "Africa", "Europe", "North America", "South America", "Oceania"]
sizes = [59.5, 17.2, 9.6, 7.7, 5.5, 0.5]

# Text parameters
title = "World Population Distribution by Continent"
suptitle = "A Visual Representation of Population Percentage"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot setup
fig, ax = plt.subplots(figsize=(8, 8))

# New color scheme
colors = ["#ff9999","#66b3ff","#99ff99","#ffcc99","#c2c2f0","#ffb3e6"]
explode = (0.1, 0, 0, 0, 0, 0)  # Highlighting Asia

wedges, texts, autotexts = ax.pie(
    sizes,
    explode=explode,
    colors=colors,
    autopct="%1.1f%%",
    shadow=False,
    startangle=140,
)

# Adding annotations
bbox_props = dict(boxstyle="square,pad=0.3", fc="w", ec="k", lw=0.72)
kw = dict(arrowprops=dict(arrowstyle="-"), bbox=bbox_props, zorder=0, va="center")

for i, p in enumerate(wedges):
    ang = (p.theta2 - p.theta1) / 2.0 + p.theta1
    y = np.sin(np.deg2rad(ang))
    x = np.cos(np.deg2rad(ang))
    horizontalalignment = {-1: "right", 1: "left"}[int(np.sign(x))]
    connectionstyle = "angle,angleA=0,angleB={}".format(ang)
    kw["arrowprops"].update({"connectionstyle": connectionstyle})
    ax.annotate(
        labels[i],
        xy=(x, y),
        xytext=(1.35 * np.sign(x), 1.2 * y),
        horizontalalignment=horizontalalignment,
        **kw
    )

# Title and equal axis
fig.suptitle(suptitle, fontsize=18, x=0.5, y=1.05)
ax.set_title(title, fontsize=16, x=0.5, y=1)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("pie_42.pdf", bbox_inches="tight")
