
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# New data for environmental science domain
labels = ["Solar", "Wind", "Hydro", "Geothermal", "Biomass"]
outer_sizes = [250, 300, 200, 150, 100]  # Nationwide energy source distribution
inner_sizes = [100, 120, 80, 60, 40]  # Project-specific energy source distribution

# Text labels
title = "Renewable Energy Consumption - National vs. Project"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 8))

# New color schemes for environmental themes
outer_colors = ["#ffddc1", "#afd3e2", "#ccff99", "#c0ca33", "#d7ccc8"]
inner_colors = ["#f8bbd0", "#b2dfdb", "#dcedc8", "#ffecb3", "#8c9eff"]

# Explode the first slice (Solar) for emphasis
explode_outer = (0.1, 0, 0, 0, 0)

# Outer ring
wedges, texts, autotexts = ax.pie(
    outer_sizes,
    labels=labels,
    radius=1.2,
    colors=outer_colors,
    explode=explode_outer,
    autopct="%1.1f%%",
    pctdistance=0.85,
    startangle=140,
)

# Inner ring
wedges2, texts2, autotexts2 = ax.pie(
    inner_sizes,
    radius=0.8,
    colors=inner_colors,
    autopct="%1.1f%%",
    pctdistance=0.75,
    startangle=140,
)

# Equal aspect ratio ensures that pie chart is drawn as a circle
ax.axis("equal")

# Title for the double-layer pie chart
ax.set_title(title, fontsize=20, y=1.05)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("pie_47.pdf", bbox_inches="tight")
