
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
transport_means = [
    "Car",
    "Bus",
    "Bicycle",
    "Train",
    "Walking",
    "Airplane",
]

data = [40, 25, 10, 15, 5, 5]
title = "Transportation Usage Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 6), subplot_kw=dict(aspect="equal"))
colors = ["#66b3ff","#99ff99","#ffcc99","#c2c2f0","#ff6666","#c4e17f"]
wedges, texts = ax.pie(data, wedgeprops=dict(width=0.4), startangle=-40, colors=colors)

bbox_props = dict(boxstyle="round,pad=0.3", fc="w", ec="k", lw=0.72)
kw = dict(arrowprops=dict(arrowstyle="-|>", lw=1), bbox=bbox_props, zorder=0, va="center")

for i, p in enumerate(wedges):
    ang = (p.theta2 - p.theta1) / 2.0 + p.theta1
    y = np.sin(np.deg2rad(ang))
    x = np.cos(np.deg2rad(ang))
    horizontalalignment = {-1: "right", 1: "left"}[int(np.sign(x))]
    connectionstyle = f"angle,angleA=0,angleB={ang}"
    kw["arrowprops"].update({"connectionstyle": connectionstyle})
    ax.annotate(
        transport_means[i] + f": {data[i]}%",
        xy=(x, y),
        xytext=(1.35 * np.sign(x), 1.4 * y),
        horizontalalignment=horizontalalignment,
        **kw,
    )

ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("pie_50.pdf", bbox_inches="tight")
