
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================

# New data for a political campaign budget
labels = ["Advertising", "Staff Salaries", "Events", "Travel", "Miscellaneous"]
outer_sizes = [500, 300, 150, 100, 50]  # Total campaign budget allocation
inner_sizes = [120, 90, 30, 20, 10]  # Budget allocation for a specific rally

title = "Political Campaign Budget Allocation"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 8))

outer_colors = ["#4c72b0", "#55a868", "#c44e52", "#8172b3", "#ccb974"]
inner_colors = ["#77bedb", "#59c794", "#f28e2b", "#f2c398", "#e15759"]
outer_hatch = ["/", "\\", "|", "-", "+"]  # Different hatching for outer ring
inner_hatch = ["x", "*", "o", "O", "."]  # Different hatching for inner ring

explode_outer = (0.1, 0, 0, 0, 0)  # only explode the 1st slice

# Outer ring
wedges, texts, autotexts = ax.pie(
    outer_sizes,
    labels=labels,
    radius=1.2,
    colors=outer_colors,
    explode=explode_outer,
    autopct="%1.1f%%",
    pctdistance=0.85,
    startangle=140,
    wedgeprops=dict(width=0.3, edgecolor="w", hatch="*"),
)

# Inner ring
wedges2, texts2, autotexts2 = ax.pie(
    inner_sizes,
    radius=0.9,
    colors=inner_colors,
    autopct="%1.1f%%",
    pctdistance=0.75,
    startangle=140,
    wedgeprops=dict(width=0.3, edgecolor="w", hatch="o"),
)

# Customizing the autotexts for better visibility
for autotext in autotexts + autotexts2:
    autotext.set_color("black")
    autotext.set_fontsize(10)

# Title for the double layer pie chart
ax.set_title(title, fontsize=16, y=1.05)

# ===================
# Part 4: Saving Output
# ===================
# Improve layout to make room for legend or labels if necessary
plt.tight_layout()

# Show the plot
plt.savefig("pie_53.pdf", bbox_inches="tight")
