
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for the charts
labels = ["Rationalism", "Empiricism", "Existentialism", "Stoicism"]
pre_20th_century_data = [30, 25, 20, 25]
modern_philosophy_data = [20, 20, 30, 30]

titles = ["Pre-20th Century Philosophy", "Modern Philosophy"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with specific dimensions
fig, ax = plt.subplots(1, 2, figsize=(10, 4))

colors = ["#4f6d7a", "#c0cad0", "#d49a89", "#a7c5bd"]

# Pre-20th Century Philosophy Donut Chart
explode1 = (0.1, 0, 0, 0)
ax[0].pie(
    pre_20th_century_data,
    labels=labels,
    colors=colors,
    startangle=140,
    counterclock=False,
    wedgeprops=dict(width=0.3, edgecolor='w'),
    explode=explode1,
    autopct="%1.1f%%",
    shadow=True
)
ax[0].set_title(titles[0], fontsize=14, fontweight='bold')

# Modern Philosophy Donut Chart
explode2 = (0, 0, 0.1, 0)
ax[1].pie(
    modern_philosophy_data,
    labels=labels,
    colors=colors,
    startangle=140,
    counterclock=False,
    wedgeprops=dict(width=0.3, edgecolor='w'),
    explode=explode2,
    autopct="%1.1f%%",
    shadow=True
)
ax[1].set_title(titles[1], fontsize=14, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap and Show plot
plt.tight_layout()
plt.savefig("pie_54.pdf", bbox_inches="tight")
