
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Example data for education domain
categories = ["Lectures", "Assignments", "Self-study", "Extracurricular Activities", "Breaks"]
sizes = [30, 25, 20, 15, 10]  # Hypothetical distribution of time spent
# Variables for plot configuration
title_text = "Time Distribution in Educational Activities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 8))

# New color scheme for educational data
colors = ["#ffcccb", "#add8e6", "#90ee90", "#ffd700", "#dda0dd"]
explode = (0, 0.1, 0, 0, 0)  # Slightly "explode" the Assignments slice

# The pie function also handles donuts with the 'wedgeprops' argument
wedges, texts, autotexts = ax.pie(
    sizes,
    labels=categories,
    colors=colors,
    autopct="%1.1f%%",
    startangle=90,
    explode=explode,
    wedgeprops=dict(width=0.4, edgecolor="w"),
)

# Draw a circle at the center of pie to make it a donut
centre_circle = plt.Circle((0, 0), 0.70, fc="white")
fig.gca().add_artist(centre_circle)

# Equal aspect ratio ensures that the pie is drawn as a circle
ax.axis("equal")

# Set title for the donut chart
ax.set_title(title_text, fontsize=16)

# Auto-Label the wedges for better readability
for text in autotexts:
    text.set_color("black")
    text.set_fontsize(12)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("pie_61.pdf", bbox_inches="tight")
