
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# New example data for the double layer donut chart
vals1 = [180, 120, 160, 240]  # Example: Painting, Sculpture, Digital Art, Craft
vals2 = [90, 90, 60, 60, 80, 80, 120, 120]  # Corresponding sub-categories
vals3 = [700]  # This will be the white center

# Define labels and colors
labels1 = ["Painting", "Sculpture", "Digital Art", "Craft"]
labels2 = ["Oil", "Watercolor", "Bronze", "Marble", "3D", "2D", "Knitting", "Pottery"]

title_text = "Popularity of Art Mediums and Their Sub-categories"

legend_labels1 = labels1
legend_labels2 = labels2

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 7))
# Variables for plot configuration
colors1 = ["#FFB6C1", "#FF69B4", "#FFDAB9", "#E6E6FA"]
colors2 = ["#FFA07A", "#FA8072", "#FF6347", "#FF4500", "#FFDEAD", "#FF8C00", "#FFD700", "#FFE4B5"]

legend_bbox_to_anchor = (1, 0.5)
legend_frameon = False

# Outer donut chart
wedges1, texts1, autotexts1 = ax.pie(
    vals1,
    labels=labels1,
    radius=1.3,
    colors=colors1,
    autopct="%1.1f%%",
    pctdistance=0.85,
    wedgeprops=dict(width=0.3, edgecolor="w"),
)

# Inner donut chart
wedges2, texts2, autotexts2 = ax.pie(
    vals2,
    radius=1.0,
    colors=colors2,
    autopct="%1.1f%%",
    pctdistance=0.75,
    wedgeprops=dict(width=0.3, edgecolor="w"),
)

# White center circle for the 'hole'
ax.pie(vals3, radius=0.7, colors="w", wedgeprops=dict(width=0.3, edgecolor="w"))

# Equal aspect ratio ensures that pie chart is drawn as a circle
ax.axis("equal")

# Title for the donut chart
ax.set_title(title_text, fontsize=14, fontweight='bold')

# Show the plot with a legend for main categories
first_legend = plt.legend(wedges1, legend_labels1, title="Art Mediums", bbox_to_anchor=(1, 0.75), frameon=legend_frameon)
plt.gca().add_artist(first_legend)

# Show the plot with a legend for sub-categories
plt.legend(wedges2, legend_labels2, title="Sub-categories", bbox_to_anchor=(1, 0.5), frameon=legend_frameon)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("pie_65.pdf", bbox_inches="tight")
