
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data to plot
sizes = [
    40.2,
    25.8,
    18.3,
    10.2,
    5.5,
]  # New data of market share percentages for tech products
labels = ["Smartphones", "Laptops", "Tablets", "Wearables", "Others"]

# Plot configuration
title = "Market Share Distribution of Technology Product Categories"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
explode = (0.1, 0, 0, 0.1, 0)  # add explode parameter to separate slices
title_pad = 20
autopct_format = "%1.1f%%"
startangle = 140
wedgeprops = dict(edgecolor="w", linewidth=1.5)

# Color palette for technology categories
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]

# Plot
fig, ax = plt.subplots(figsize=(8, 8))
ax.pie(
    sizes,
    colors=colors,
    autopct=autopct_format,
    startangle=startangle,
    wedgeprops=wedgeprops,
    explode=explode,
    labels=labels,
)
ax.set_title(title, pad=title_pad)  # Set the title with padding

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("pie_69.pdf", bbox_inches="tight")
