
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data to plot
labels = ["Ancient History", "Middle Ages", "Renaissance", "Industrial Revolution", "Modern History"]
sizes = [25, 15, 20, 10, 30]

# Extracted variables
plot_title = "Popularity of Historical Periods"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#8d5524", "#c68642", "#e0ac69", "#f1c27d", "#ffdbac"]
explode = (0.1, 0, 0, 0, 0.1)  # Highlight the two largest segments

autopct_format = "%1.1f%%"
shadow_option = True
start_angle = 140
legend_location = "best"
legend_fontsize = 10
title_fontsize = 18
title_y_position = 1.08
# Plot
plt.figure(figsize=(10, 8))
plt.pie(
    sizes,
    explode=explode,
    colors=colors,
    autopct=autopct_format,
    shadow=shadow_option,  # Add shadow for depth
    startangle=start_angle,
)
plt.axis("equal")

# Add legend
plt.legend(labels, loc=legend_location, fontsize=legend_fontsize)
plt.title(plot_title, fontsize=title_fontsize, y=title_y_position)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("pie_79.pdf", bbox_inches="tight")
