
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the vector field function
def vector_field(X, Y):
    # Function simulating performance improvement
    U = -Y
    V = X
    return U, V

def modified_vector_field(X, Y):
    # Modified function simulating different performance improvement
    U = -1 - X**2 + Y
    V = 1 + X - Y**2
    return U, V

# Create a grid of points
x = np.linspace(0, 0.6, 10)
y = np.linspace(0, 0.6, 10)
X, Y = np.meshgrid(x, y)

# Compute the vector fields
U, V = vector_field(X, Y)
U_mod, V_mod = modified_vector_field(X, Y)

# Generate data for performance curves
x = np.linspace(0.2, 0.5, 100)

# Labels and legends
xlabel = "Effort"
ylabel = "Performance"
patch_labels = ["Actual Performance", "Predicted Performance"]
line_labels = ["Train Performance", "Test Performance", "Model Train", "Model Test"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 6))
plt.quiver(X, Y, U, V, color="#ff9999", alpha=0.6)
plt.quiver(X, Y, U_mod, V_mod, color="#66b3ff", alpha=0.6)
plt.plot(x, 0.09 / (x**1.2), color="#99ff99", linestyle='--')
plt.plot(x, 0.08 / (x**1.2 + 0.04), color="#ffcc99", linestyle=':')
plt.plot(x, 0.075 / (x**1 + 0.04), color="#c2c2f0", linestyle='-.')
plt.plot(x, 0.12 / (x**1 + 0.05), color="#ffb3e6", linestyle='-')

# Add labels and legend
plt.xlabel(xlabel, fontsize=14, style="italic")
plt.ylabel(ylabel, fontsize=14, style="italic")

red_patch = mpatches.Patch(color="#ff9999", label=patch_labels[0], alpha=0.6)
blue_patch = mpatches.Patch(color="#66b3ff", label=patch_labels[1], alpha=0.6)

# Create legend for curves
train_line = mlines.Line2D([], [], color="#99ff99", label=line_labels[0], linestyle='--')
test_line = mlines.Line2D([], [], color="#ffcc99", label=line_labels[1], linestyle=':')
sindy_train_line = mlines.Line2D([], [], color="#c2c2f0", label=line_labels[2], linestyle='-.')
sindy_test_line = mlines.Line2D([], [], color="#ffb3e6", label=line_labels[3], linestyle='-')

# Combine all legend handles
handles = [
    red_patch,
    blue_patch,
    train_line,
    test_line,
    sindy_train_line,
    sindy_test_line,
]

# Add the legend to the plot with specified location
plt.legend(handles=handles, loc="lower left")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("quiver_28.pdf", bbox_inches="tight")
