# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data for the plot (Law Firms)
firms_1 = ["Firm A", "Firm B", "Firm C"]
market_share_initial_1 = [25, 15, 30]
market_share_change_1 = [5, 2, 3]
revenue_initial_1 = [40, 35, 50]
revenue_change_1 = [7, 5, 8]
ax1_labels = ["Revenue Growth (Large Firms)", "Market Share Growth (Large Firms)"]

firms_2 = ["Firm D", "Firm E", "Firm F"]
market_share_initial_2 = [10, 20, 5]
market_share_change_2 = [3, 4, 1]
revenue_initial_2 = [25, 30, 15]
revenue_change_2 = [4, 6, 2]
ax2_labels = ["Revenue Growth (Small Firms)", "Market Share Growth (Small Firms)"]

xlabel = "Growth Metrics"
ylabel = "Law Firms"
title = "Law Firm Market and Revenue Growth Metrics"
figtitle = "Law Firms' Revenue and Market Share Growth"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with two subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(14, 6))
fig.suptitle(figtitle)

# Set the y-axis offsets to be in the middle of each grid
offset = 0.5

# First subplot (firms_1)
for i, firm in enumerate(firms_1):
    # Revenue growth line with arrow and black dots at start and end
    ax1.annotate(
        "",
        xy=(revenue_initial_1[i], i + offset * 3 / 2),
        xytext=(revenue_initial_1[i] + revenue_change_1[i], i + offset * 3 / 2),
        arrowprops=dict(arrowstyle="<-", color="blue"),
    )
    ax1.scatter(
        [revenue_initial_1[i], revenue_initial_1[i] + revenue_change_1[i]],
        [i + offset * 3 / 2, i + offset * 3 / 2],
        color="black",
        s=10,
        marker="s",  # square marker for revenue
    )
    ax1.annotate(
        f"{revenue_change_1[i]:.2f}",
        (revenue_initial_1[i] + revenue_change_1[i], i + offset * 1.75),
        color="blue",
        ha="right",
        va="center",
    )

    # Market share growth line with arrow and black dots at start and end
    ax1.annotate(
        "",
        xy=(market_share_initial_1[i], i + offset / 2),
        xytext=(market_share_initial_1[i] + market_share_change_1[i], i + offset / 2),
        arrowprops=dict(arrowstyle="<-", color="green"),
    )
    ax1.scatter(
        [
            market_share_initial_1[i],
            market_share_initial_1[i] + market_share_change_1[i],
        ],
        [i + offset / 2, i + offset / 2],
        color="black",
        s=10,
        marker="^",  # triangle marker for market share
    )
    ax1.annotate(
        f"{market_share_change_1[i]:.2f}",
        (market_share_initial_1[i] + market_share_change_1[i], i + offset * 0.75),
        color="green",
        ha="left",
        va="center",
    )

# Second subplot (firms_2)
for i, firm in enumerate(firms_2):
    ax2.annotate(
        "",
        xy=(revenue_initial_2[i], i + offset * 3 / 2),
        xytext=(revenue_initial_2[i] + revenue_change_2[i], i + offset * 3 / 2),
        arrowprops=dict(arrowstyle="<-", color="blue"),
    )
    ax2.scatter(
        [revenue_initial_2[i], revenue_initial_2[i] + revenue_change_2[i]],
        [i + offset * 3 / 2, i + offset * 3 / 2],
        color="black",
        s=10,
        marker="s",  # square marker for revenue
    )
    ax2.annotate(
        f"{revenue_change_2[i]:.2f}",
        (revenue_initial_2[i] + revenue_change_2[i], i + offset * 1.75),
        color="blue",
        ha="right",
        va="center",
    )

    ax2.annotate(
        "",
        xy=(market_share_initial_2[i], i + offset / 2),
        xytext=(market_share_initial_2[i] + market_share_change_2[i], i + offset / 2),
        arrowprops=dict(arrowstyle="<-", color="green"),
    )
    ax2.scatter(
        [
            market_share_initial_2[i],
            market_share_initial_2[i] + market_share_change_2[i],
        ],
        [i + offset / 2, i + offset / 2],
        color="black",
        s=10,
        marker="^",  # triangle marker for market share
    )
    ax2.annotate(
        f"{market_share_change_2[i]:.2f}",
        (market_share_initial_2[i] + market_share_change_2[i], i + offset * 0.75),
        color="green",
        ha="left",
        va="center",
    )

# Set y-axis limits
ax1.set_ylim(0, len(firms_1))
ax2.set_ylim(0, len(firms_2))

# Set x-axis limits uniformly
ax1.set_xlim(0, 60)
ax2.set_xlim(0, 60)

# Adjust the y-axis tick positions
ax1.set_yticks([i + offset for i in range(len(firms_1))])
ax1.set_yticklabels(firms_1)
ax2.set_yticks([i + offset for i in range(len(firms_2))])
ax2.set_yticklabels(firms_2)
ax2.yaxis.tick_right()
ax2.yaxis.set_label_position("right")

# Offset grid lines on the y-axis
ax1.set_yticks([i for i in range(len(firms_1))], minor=True)
ax2.set_yticks([i for i in range(len(firms_2))], minor=True)
ax1.yaxis.grid(True, which="minor", linewidth=0.5, alpha=0.5, color="black")
ax2.yaxis.grid(True, which="minor", linewidth=0.5, alpha=0.5, color="black")

# Add x-axis grid lines and set gap to 10
ax1.xaxis.set_major_locator(plt.MultipleLocator(10))
ax2.xaxis.set_major_locator(plt.MultipleLocator(10))
ax1.grid(axis="x", linestyle="--", linewidth=0.5)
ax2.grid(axis="x", linestyle="--", linewidth=0.5)

# Create arrow-shaped legend entries with a line that aligns with the arrowhead
blue_arrow = mlines.Line2D(
    [],
    [],
    color="blue",
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax1_labels[0],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
green_arrow = mlines.Line2D(
    [],
    [],
    color="green",
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax1_labels[1],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
fig.legend(handles=[blue_arrow, green_arrow], bbox_to_anchor=(0.45, 0.0), ncol=2)

blue_arrow = mlines.Line2D(
    [],
    [],
    color="blue",
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax2_labels[0],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
green_arrow = mlines.Line2D(
    [],
    [],
    color="green",
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax2_labels[1],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
fig.legend(handles=[blue_arrow, green_arrow], bbox_to_anchor=(0.95, 0.0), ncol=2)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("quiver_41.pdf", bbox_inches="tight")
