
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the vector field function for wind patterns
def wind_field(X, Y):
    U = -Y
    V = X
    return U, V

# Define a modified vector field considering terrain influence
def terrain_influenced_wind_field(X, Y):
    U = -0.5 - X**2 + Y
    V = 0.5 + X - Y**2
    return U, V

# Create a grid of points
x = np.linspace(0, 0.8, 10)
y = np.linspace(0, 0.8, 10)
X, Y = np.meshgrid(x, y)

# Compute the vector fields
U, V = wind_field(X, Y)
U_mod, V_mod = terrain_influenced_wind_field(X, Y)

# Plot curves representing crop growth and decay rates
x = np.linspace(0.2, 0.5, 100)
xlabel = "Field Position X"
ylabel = "Field Position Y"
patch_labels = ["Wind Patterns", "Terrain Influenced Wind Patterns"]
line_labels = ["Crop Growth Rate", "Crop Decay Rate", "Predicted Growth", "Predicted Decay"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 8))

# Plot the vector fields
plt.quiver(X, Y, U, V, color="#7a9f35", alpha=0.6)
plt.quiver(X, Y, U_mod, V_mod, color="#b6854d", alpha=0.6)

# Plot the growth and decay rates
plt.plot(x, 0.09 / (x**1.2), color="#6fad25", linestyle="-", linewidth=2)
plt.plot(x, 0.08 / (x**1.2 + 0.04), color="#a16207", linestyle="--", linewidth=2)
plt.plot(x, 0.075 / (x**1 + 0.04), color="#4e6c20", linestyle="-.", linewidth=2)
plt.plot(x, 0.12 / (x**1 + 0.05), color="#8f4a00", linestyle=":", linewidth=2)

# Add labels and legend
plt.xlabel(xlabel, fontsize=16, style="italic")
plt.ylabel(ylabel, fontsize=16, style="italic")

# Create patches and lines for the legend
wind_patch = mpatches.Patch(color="#7a9f35", label=patch_labels[0], alpha=0.6)
terrain_patch = mpatches.Patch(color="#b6854d", label=patch_labels[1], alpha=0.6)

growth_line = mlines.Line2D([], [], color="#6fad25", label=line_labels[0], linestyle="-")
decay_line = mlines.Line2D([], [], color="#a16207", label=line_labels[1], linestyle="--")
predicted_growth_line = mlines.Line2D([], [], color="#4e6c20", label=line_labels[2], linestyle="-.")
predicted_decay_line = mlines.Line2D([], [], color="#8f4a00", label=line_labels[3], linestyle=":")

# Combine all legend handles
handles = [wind_patch, terrain_patch, growth_line, decay_line, predicted_growth_line, predicted_decay_line]

# Add the legend to the plot
plt.legend(handles=handles, loc="lower left")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("quiver_48.pdf", bbox_inches="tight")
