# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)


# Define the vector field function for an economic model
def economic_vector_field(X, Y):
    U = -Y
    V = X
    return U, V


def modified_economic_vector_field(X, Y):
    U = -1 - X**2 + Y
    V = 1 + X - Y**2
    return U, V


# Create a grid of points
x = np.linspace(0, 0.8, 10)
y = np.linspace(0, 0.8, 10)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = economic_vector_field(X, Y)

# Compute the modified vector field
U_mod, V_mod = modified_economic_vector_field(X, Y)

# Plot the curves as inverse functions with slightly different denominators for variation
x = np.linspace(0.2, 0.5, 100)
xlabel = "Demand (Units)"
ylabel = "Supply (Units)"
patch_labels = ["Baseline Economic Field", "Modified Economic Field"]
line_labels = ["Historical Data", "Projected Data", "Model Prediction", "Forecast"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 8))
plt.quiver(X, Y, U, V, color="#1f77b4", alpha=0.6)
plt.quiver(X, Y, U_mod, V_mod, color="#ff7f0e", alpha=0.6)

plt.plot(x, 0.09 / (x**1.2), color="#2ca02c", linestyle="-", linewidth=2)
plt.plot(x, 0.08 / (x**1.2 + 0.04), color="#d62728", linestyle="--", linewidth=2)
plt.plot(x, 0.075 / (x**1 + 0.04), color="#9467bd", linestyle="-.", linewidth=2)
plt.plot(x, 0.12 / (x**1 + 0.05), color="#8c564b", linestyle=":", linewidth=2)

# Add labels and legend
plt.xlabel(xlabel, fontsize=16, style="italic")
plt.ylabel(ylabel, fontsize=16, style="italic")

red_patch = mpatches.Patch(color="#1f77b4", label=patch_labels[0], alpha=0.6)
blue_patch = mpatches.Patch(color="#ff7f0e", label=patch_labels[1], alpha=0.6)

# Create legend for curves
train_line = mlines.Line2D([], [], color="#2ca02c", label=line_labels[0], linestyle="-")
test_line = mlines.Line2D([], [], color="#d62728", label=line_labels[1], linestyle="--")
sindy_train_line = mlines.Line2D(
    [], [], color="#9467bd", label=line_labels[2], linestyle="-."
)
sindy_test_line = mlines.Line2D(
    [], [], color="#8c564b", label=line_labels[3], linestyle=":"
)

# Combine all legend handles
handles = [
    red_patch,
    blue_patch,
    train_line,
    test_line,
    sindy_train_line,
    sindy_test_line,
]

# Add the legend to the plot with specified location
plt.legend(handles=handles, loc="lower left")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("quiver_50.pdf", bbox_inches="tight")
