# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)


# Define the vector field function for market forces (supply and demand)
def market_vector_field(X, Y):
    # Placeholder function for the vector field
    U = -X
    V = Y
    return U, V


def modified_market_vector_field(X, Y):
    # Modified market forces
    U = -0.5 - X**2 + Y
    V = 0.5 + X - Y**2
    return U, V


# Create a grid of points representing market scenarios
x = np.linspace(0, 1, 10)
y = np.linspace(0, 1, 10)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = market_vector_field(X, Y)

# Compute the modified vector field
U_mod, V_mod = modified_market_vector_field(X, Y)

# Plot the curves representing different economic trends
x = np.linspace(0.3, 0.6, 100)  # Updated range for market scenarios
xlabel = "Price (USD)"
ylabel = "Quantity (units)"
patch_labels = ["Supply Influence", "Demand Influence"]
line_labels = ["Supply Curve", "Demand Curve", "Adjusted Supply", "Adjusted Demand"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 6))

# Quiver plots for market forces
plt.quiver(X, Y, U, V, color="#1f77b4", alpha=0.6)  # Supply Influence
plt.quiver(X, Y, U_mod, V_mod, color="#ff7f0e", alpha=0.6)  # Demand Influence

# Plot different economic trends
plt.plot(x, 0.09 / (x**1.2), color="#2ca02c", linestyle="-", linewidth=2)
plt.plot(x, 0.08 / (x**1.2 + 0.04), color="#d62728", linestyle="--", linewidth=2)
plt.plot(x, 0.075 / (x**1 + 0.04), color="#9467bd", linestyle="-.", linewidth=2)
plt.plot(x, 0.12 / (x**1 + 0.05), color="#8c564b", linestyle=":", linewidth=2)

# Add labels and legend
plt.xlabel(xlabel, fontsize=14, style="italic")
plt.ylabel(ylabel, fontsize=14, style="italic")

# Patches for vector fields
blue_patch = mpatches.Patch(color="#1f77b4", label=patch_labels[0], alpha=0.6)
orange_patch = mpatches.Patch(color="#ff7f0e", label=patch_labels[1], alpha=0.6)

# Lines for economic trends
supply_curve = mlines.Line2D(
    [], [], color="#2ca02c", linestyle="-", label=line_labels[0], linewidth=2
)
demand_curve = mlines.Line2D(
    [], [], color="#d62728", linestyle="--", label=line_labels[1], linewidth=2
)
adjusted_supply = mlines.Line2D(
    [], [], color="#9467bd", linestyle="-.", label=line_labels[2], linewidth=2
)
adjusted_demand = mlines.Line2D(
    [], [], color="#8c564b", linestyle=":", label=line_labels[3], linewidth=2
)

# Combine all legend handles
handles = [
    blue_patch,
    orange_patch,
    supply_curve,
    demand_curve,
    adjusted_supply,
    adjusted_demand,
]

# Add the legend to the plot with specified location
plt.legend(handles=handles, loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("quiver_51.pdf", bbox_inches="tight")
