
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the vector field function for wind flow
def wind_vector_field(X, Y):
    U = -Y
    V = X
    return U, V

def modified_wind_vector_field(X, Y):
    U = -1 - X**2 + Y
    V = 1 + X - Y**2
    return U, V

# Create a grid of points representing locations
x = np.linspace(0, 1, 10)
y = np.linspace(0, 1, 10)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = wind_vector_field(X, Y)

# Compute the modified vector field
U_mod, V_mod = modified_wind_vector_field(X, Y)

# Plot the curves representing different flight paths
x = np.linspace(0.3, 0.6, 100)
xlabel = "Distance (km)"
ylabel = "Wind Speed (m/s)"
patch_labels = ["Normal Wind Flow", "Modified Wind Flow"]
line_labels = ["Path A", "Path B", "Path C", "Path D"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 6))

# Quiver plots for wind flow
plt.quiver(X, Y, U, V, color="#4682B4", alpha=0.6)  # Normal Flow
plt.quiver(X, Y, U_mod, V_mod, color="#DC143C", alpha=0.6)  # Modified Flow

# Plot different flight paths
plt.plot(x, 0.09 / (x**1.2), color="#32CD32", linestyle="-", linewidth=2)
plt.plot(x, 0.08 / (x**1.2 + 0.04), color="#FFA500", linestyle="--", linewidth=2)
plt.plot(x, 0.075 / (x**1 + 0.04), color="#8B4513", linestyle="-.", linewidth=2)
plt.plot(x, 0.12 / (x**1 + 0.05), color="#000080", linestyle=":", linewidth=2)

# Add labels and legend
plt.xlabel(xlabel, fontsize=14, style="italic")
plt.ylabel(ylabel, fontsize=14, style="italic")

# Patches for vector fields
blue_patch = mpatches.Patch(color="#4682B4", label=patch_labels[0], alpha=0.6)
red_patch = mpatches.Patch(color="#DC143C", label=patch_labels[1], alpha=0.6)

# Lines for flight paths
path_a = mlines.Line2D([], [], color="#32CD32", linestyle="-", label=line_labels[0], linewidth=2)
path_b = mlines.Line2D([], [], color="#FFA500", linestyle="--", label=line_labels[1], linewidth=2)
path_c = mlines.Line2D([], [], color="#8B4513", linestyle="-.", label=line_labels[2], linewidth=2)
path_d = mlines.Line2D([], [], color="#000080", linestyle=":", label=line_labels[3], linewidth=2)

# Combine all legend handles
handles = [blue_patch, red_patch, path_a, path_b, path_c, path_d]

# Add the legend to the plot with specified location
plt.legend(handles=handles, loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("quiver_52.pdf", bbox_inches="tight")
