
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Define the vector field function for player movements
def player_movement_vector_field(X, Y):
    U = np.cos(2 * np.pi * X / 100) * np.sin(np.pi * Y / 100)
    V = np.sin(np.pi * X / 100) * np.cos(2 * np.pi * Y / 100)
    return U, V

# Create a grid of points
x = np.linspace(-50.0, 50.0, 20)
y = np.linspace(-50.0, 50.0, 20)
X, Y = np.meshgrid(x, y)

# Compute the vector field for player movements
U, V = player_movement_vector_field(X, Y)
speed = np.sqrt(U**2 + V**2)

xlabel = "X Coordinate"
ylabel = "Y Coordinate"
title = "Simulated Player Movements on a Soccer Field"
cbar_label = "Movement Speed"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 7))
Q = ax.quiver(X, Y, U, V, speed, cmap="coolwarm", alpha=0.9)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=12, fontweight='bold')
ax.set_ylabel(ylabel, fontsize=12, fontweight='bold')
ax.set_title(title, fontsize=14, fontweight='bold')

# Show grid
ax.grid(True, linestyle="-", alpha=0.7)

# Add a color bar
cbar = fig.colorbar(Q, ax=ax)
cbar.set_label(cbar_label, fontsize=12, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_64.pdf", bbox_inches="tight")
