
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Define the vector field function for religious community distribution
def religious_vector_field(X, Y):
    # Hypothetical function representing social dynamics of religious communities
    U = np.sin(Y / 3.0) * 2
    V = np.cos(X / 3.0) * 2
    return U, V

# Create a finer grid of points (representing a geographical area)
x = np.linspace(-15.0, 15.0, 30)
y = np.linspace(-15.0, 15.0, 30)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = religious_vector_field(X, Y)
xlabel = "Longitude"
ylabel = "Latitude"
title = "Distribution of Religious Communities"
cbar_label = "Community Influence"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 6))
# Use a more spiritual-themed color scheme
colors = np.sqrt(U**2 + V**2)
quiver = ax.quiver(X, Y, U, V, colors, cmap="viridis")

# Add several streamlines to the vector field plot for better visualization
strm = ax.streamplot(X, Y, U, V, color="purple", linewidth=0.5)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14, pad=15)

# Show grid
ax.grid(True, linestyle="--", alpha=0.7)

# Add color bar
cbar = plt.colorbar(quiver, ax=ax)
cbar.set_label(cbar_label, rotation=270, labelpad=15)

# Adjust the aspect ratio
ax.set_aspect("equal")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Display the plot
plt.savefig("quiver_74.pdf", bbox_inches="tight")
