
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the vector field function for coastal air flow
def coastal_wind_field(X, Y):
    # Simulated coastal wind flow pattern
    U = -np.sin(np.pi * X / 2) * np.cos(np.pi * Y / 4)
    V = np.cos(np.pi * X / 4) * np.sin(np.pi * Y / 2)
    return U, V

# Create a finer grid of points
x = np.linspace(-5.0, 5.0, 20)
y = np.linspace(-5.0, 5.0, 20)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = coastal_wind_field(X, Y)
xlabel = "Longitude (degrees)"
ylabel = "Latitude (degrees)"
title = "Coastal Air Circulation Patterns"
colorbar_title = "Wind Speed (m/s)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 6))

# Use a coastal-themed color scheme
colors = np.sqrt(U**2 + V**2)
quiver = ax.quiver(X, Y, U, V, colors, cmap="coolwarm")

# Add several streamlines to the vector field plot
strm = ax.streamplot(X, Y, U, V, color="darkblue", linewidth=0.5, density=1.2)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid, set grid style
ax.grid(True, linestyle="--", alpha=0.7)

# Adjust the aspect ratio
ax.set_aspect("equal")

# Add color bar to indicate the magnitude of the vectors
cbar = plt.colorbar(quiver, ax=ax)
cbar.set_label(colorbar_title)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Display the plot
plt.savefig("quiver_77.pdf", bbox_inches="tight")
