
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

def fluid_flow_field(X, Y):
    # Simulating a rotational fluid flow
    U = np.cos(X) - np.sin(Y)
    V = np.sin(X) + np.cos(Y)
    return U, V

# Create a grid of points
x = np.linspace(-3.0, 10.0, 15)
y = np.linspace(-3.0, 10.0, 15)
X, Y = np.meshgrid(x, y)

# Compute the fluid flow vector field
U, V = fluid_flow_field(X, Y)
magnitude = np.sqrt(U**2 + V**2)

xlabel = "X Position (m)"
ylabel = "Y Position (m)"
title = "Rotational Fluid Flow Vector Field"
colorbar_title = "Velocity Magnitude (m/s)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 8))
quiver = ax.quiver(X, Y, U, V, magnitude, cmap="viridis", scale=15)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16, weight='bold')

# Show grid with enhanced style
ax.grid(True, linestyle="--", alpha=0.7, color='grey')

# Add color bar to show magnitude
cbar = plt.colorbar(quiver, ax=ax)
cbar.set_label(colorbar_title, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_80.pdf", bbox_inches="tight")
