# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Define the data for each political figure
values1 = [78, 75, 80, 75, 70, 75, 70]  # Politician A
values2 = [65, 65, 60, 62, 60, 65, 65]  # Politician B
values3 = [50, 55, 55, 50, 55, 52, 50]  # Politician C
xlabels = [
    "Popularity",
    "Policy Effectiveness",
    "Economic Impact",
    "Media Presence",
    "Public Speaking",
    "Legislation Passed",
    "International Relations",
]
yticks = [20, 40, 60, 80]
title = "Political Performance Metrics"
labels = ["Politician A", "Politician B", "Politician C"]
ylim = [0, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the spider plot
fig, ax = plt.subplots(figsize=(8, 7), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(values1)

# Compute angle for each axis
angles = [n / float(num_vars) * 2 * pi for n in range(num_vars)]
angles += angles[:1]  # Complete the loop

# Repeat the first value to close the circle
values1 += values1[:1]
values2 += values2[:1]
values3 += values3[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], xlabels, size=10, color="black")

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, [], color="grey", size=7)
plt.ylim(ylim)

# Draw the inner circles with grey color lines
for circle in ax.get_ygridlines():
    circle.set_color("#d3d3d3")

# Plot each political figure
ax.plot(
    angles,
    values1,
    linewidth=2,
    linestyle="dashed",
    marker="o",
    label=labels[0],
    color="#1f77b4",
)
ax.fill(angles, values1, "#1f77b4", alpha=0.1)

ax.plot(
    angles,
    values2,
    linewidth=2,
    linestyle="dashed",
    marker="s",
    label=labels[1],
    color="#ff7f0e",
)
ax.fill(angles, values2, "#ff7f0e", alpha=0.1)

ax.plot(
    angles,
    values3,
    linewidth=2,
    linestyle="dashed",
    marker="^",
    label=labels[2],
    color="#2ca02c",
)
ax.fill(angles, values3, "#2ca02c", alpha=0.1)

# Add data labels
for i in range(num_vars):
    plt.text(
        angles[i],
        values1[i],
        str(values1[i]),
        horizontalalignment="center",
        size=8,
        color="black",
    )
    plt.text(
        angles[i],
        values2[i],
        str(values2[i]),
        horizontalalignment="center",
        size=8,
        color="black",
    )
    plt.text(
        angles[i],
        values3[i],
        str(values3[i]),
        horizontalalignment="center",
        size=8,
        color="black",
    )

# Add a legend and title
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.1), ncol=3)
plt.title(title, position=(0.5, -0.15), ha="center")

# Adjust figure size to match original image's dimensions
fig.set_size_inches(8, 7)
ax.spines["polar"].set_color("#d3d3d3")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("radar_24.pdf", bbox_inches="tight")
