
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the data for each technology
values1 = [70, 80, 85, 60, 75, 50, 65]  # Technology A
values2 = [80, 90, 70, 85, 65, 60, 55]  # Technology B
values3 = [60, 75, 80, 70, 80, 65, 70]  # Technology C
xlabels = ["Crop Yield", "Soil Health", "Water Usage Efficiency", "Pest Resistance", "Nutrient Usage Efficiency", "Carbon Footprint", "Cost Efficiency"]
yticks = [20, 40, 60, 80]
title = "Performance Metrics in Agriculture"
labels = ["Technology A", "Technology B", "Technology C"]
ylim = [0, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the spider plot
fig, ax = plt.subplots(figsize=(8, 7), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(values1)

# Compute angle for each axis
angles = [n / float(num_vars) * 2 * pi for n in range(num_vars)]
angles += angles[:1]  # Complete the loop

# Repeat the first value to close the circle
values1 += values1[:1]
values2 += values2[:1]
values3 += values3[:1]


# Draw one axe per variable and add labels
plt.xticks(
    angles[:-1],
    xlabels,
    size=10,
)

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, [], color="#7f9c7b", size=7)
plt.ylim(ylim)

# Draw the inner circles with green color lines
for circle in ax.get_ygridlines():
    circle.set_color("#bce2bc")

# Plot each technology
ax.plot(angles, values1, linewidth=2, linestyle="-.", marker='o', label=labels[0], color="#3288bd")
ax.fill(angles, values1, "#3288bd", alpha=0.1)

ax.plot(angles, values2, linewidth=2, linestyle="--", marker='s', label=labels[1], color="#99d594")
ax.fill(angles, values2, "#99d594", alpha=0.1)

ax.plot(angles, values3, linewidth=2, linestyle=":", marker='^', label=labels[2], color="#e6f598")
ax.fill(angles, values3, "#e6f598", alpha=0.1)

# Add data labels
for i in range(num_vars):
    plt.text(
        angles[i],
        values1[i],
        str(values1[i]),
        horizontalalignment="center",
        size=8,
        color="black",
    )
    plt.text(
        angles[i],
        values2[i],
        str(values2[i]),
        horizontalalignment="center",
        size=8,
        color="black",
    )
    plt.text(
        angles[i],
        values3[i],
        str(values3[i]),
        horizontalalignment="center",
        size=8,
        color="black",
    )

# Add a legend and title
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.1), ncol=3)
plt.title(title, position=(0.5, -0.15), ha="center")

# Adjust figure size to match original image's dimensions
fig.set_size_inches(8, 7)
ax.spines["polar"].set_color("#bce2bc")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("radar_25.pdf", bbox_inches="tight")
