
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Define the data for each religious group
labels = np.array(["Faith Strength", "Community Engagement", "Religious Knowledge", "Service Attendance", "Spiritual Practices"])
stats = np.array([[4, 5, 3, 5, 4], [3, 3, 4, 2, 5], [5, 4, 5, 4, 3]])
titles = ["Christianity", "Islam", "Buddhism"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, ax = plt.subplots(figsize=(14, 8), nrows=1, ncols=3, subplot_kw=dict(polar=True))

# Define the number of variables
num_vars = len(labels)
# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()
# The plot is made circular
stats = np.concatenate((stats, stats[:, [0]]), axis=1)
angles += angles[:1]

# Define color palette
colors = ['#1f77b4', '#ff7f0e', '#2ca02c']

# Draw one radar chart for each religious group
for idx, (title, case_data) in enumerate(zip(titles, stats)):
    thisColor = colors[idx]
    ax[idx].fill(angles, case_data, color=thisColor, alpha=0.25)
    ax[idx].plot(angles, case_data, color=thisColor, linewidth=2, linestyle='-')
    ax[idx].set_yticks([1, 2, 3, 4, 5])
    ax[idx].set_yticklabels(["1", "2", "3", "4", "5"], color='grey', size=10)
    ax[idx].set_xticks(angles[:-1])
    ax[idx].set_xticklabels(labels, fontsize=12)
    ax[idx].set_title(title, size=16, color='black', position=(0.5, 1.1))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit
plt.tight_layout()

# Show the plot
plt.savefig("radar_30.pdf", bbox_inches="tight")
