
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Data for the radar chart
labels = np.array(
    [
        "Artificial Intelligence",
        "Cybersecurity",
        "Blockchain",
        "IoT",
        "Cloud Computing",
        "Quantum Computing",
        "5G Technology",
        "AR/VR",
        "Robotics",
        "Edge Computing",
    ]
)

# Adoption rates for the current year and the previous year
current_year_values = np.array([85, 75, 60, 70, 90, 50, 95, 45, 55, 65])
previous_year_values = np.array([65, 55, 40, 50, 70, 30, 75, 25, 35, 45])

yticks = [20, 40, 60, 80, 100]
ytickslabel = ["20", "40", "60", "80", "100"]
ylim = [0, 100]
labels2 = ["Previous Year", "Current Year"]
rgrids = [20, 40, 60, 80, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the figure
fig, ax = plt.subplots(figsize=(10, 10), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is circular, so we need to "complete the loop" and append the start to the end.
current_year_values = np.concatenate((current_year_values, [current_year_values[0]]))
previous_year_values = np.concatenate((previous_year_values, [previous_year_values[0]]))
angles += angles[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], [], color="black", size=10, ha="right")
for angle, label in zip(angles[:-1], labels):  # Remove the appended first element
    if angle < np.pi / 2 or angle > 3 * np.pi / 2:  # If the text is at the bottom or right side of the chart
        ax.text(
            angle,
            110,
            label,
            horizontalalignment="left",
            size=10,
            verticalalignment="bottom",
        )
    else:  # If the text is at the top or left side of the chart
        ax.text(
            angle,
            110,
            label,
            horizontalalignment="right",
            size=10,
            verticalalignment="bottom",
        )

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(
    yticks,
    ytickslabel,
    color="grey",
    size=10,
)
plt.ylim(ylim)

# Plot data
ax.plot(
    angles,
    previous_year_values,
    linewidth=1.5,
    linestyle="dotted",
    label=labels2[0],
    color="teal",
    marker='o',
)
ax.fill(angles, previous_year_values, "teal", alpha=0.1)

ax.plot(
    angles,
    current_year_values,
    linewidth=1.5,
    linestyle="solid",
    label=labels2[1],
    color="coral",
    marker='s',
)
ax.fill(angles, current_year_values, "coral", alpha=0.1)

# Add legend
plt.legend(loc="upper right", bbox_to_anchor=(0.1, 0.1))

# Adjust gridlines
ax.set_rgrids(
    rgrids,
    labels=rgrids,
    angle=0,
    color="black",
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_33.pdf", bbox_inches="tight")
