# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Define the data for each line
values_profit = [0.20, 0.35, 0.25, 0.45, 0.30, 0.55]
values_customer = [0.40, 0.50, 0.45, 0.60, 0.55, 0.65]
values_market = [0.30, 0.50, 0.40, 0.55, 0.45, 0.60]
values_employee = [0.35, 0.45, 0.40, 0.50, 0.48, 0.58]
xtickslabel = ["Model_X", "Model_Y", "Model_Z", "Model_W", "Model_V", "Model_U"]
y_ticks = [0.10, 0.30, 0.50, 0.70]
labels = [
    "Profit Margin",
    "Customer Satisfaction",
    "Market Share",
    "Employee Engagement",
]
ylim = [0, 0.8]

title = "Business Model Evaluation Radar Chart"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set up the figure and polar axis
fig, ax = plt.subplots(figsize=(6, 6), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(values_profit)
# Compute angle for each axis
angles = [n / float(num_vars) * 2 * pi for n in range(num_vars)]
angles += angles[:1]  # Complete the loop

# Repeat the first value to close the circle
values_profit += values_profit[:1]
values_customer += values_customer[:1]
values_market += values_market[:1]
values_employee += values_employee[:1]

# Draw one axe per variable and add labels
plt.xticks(
    angles[:-1],
    xtickslabel,
    color="black",
    size=8,
)


# Define the range of y-axis and y-labels

plt.yticks(y_ticks, [str(i) for i in y_ticks], color="black", size=7)

# Set y-axis limit
plt.ylim(ylim)

# Plot data and fill area for each line
ax.plot(
    angles,
    values_profit,
    linewidth=2,
    linestyle="dashed",
    label=labels[0],
    color="#1f77b4",
    marker="o",
)
ax.fill(angles, values_profit, "#1f77b4", alpha=0.1)

ax.plot(
    angles,
    values_customer,
    linewidth=2,
    linestyle="dotted",
    label=labels[1],
    color="#ff7f0e",
    marker="s",
)
ax.fill(angles, values_customer, "#ff7f0e", alpha=0.1)

ax.plot(
    angles,
    values_market,
    linewidth=2,
    linestyle="dashdot",
    label=labels[2],
    color="#2ca02c",
    marker="^",
)
ax.fill(angles, values_market, "#2ca02c", alpha=0.1)

ax.plot(
    angles,
    values_employee,
    linewidth=2,
    linestyle="solid",
    label=labels[3],
    color="#d62728",
    marker="*",
)
ax.fill(angles, values_employee, "#d62728", alpha=0.1)

# Add legend with a different style
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.2), ncol=2)

# Add title
plt.title(title, size=14, color="#333333")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_38.pdf", bbox_inches="tight")
