# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Define the data for each line
labels = np.array(
    [
        "Constitutional Law",
        "Corporate Law",
        "Criminal Law",
        "Environmental Law",
        "Family Law",
        "Health Law",
        "Immigration Law",
        "Intellectual Property Law",
        "International Law",
        "Labor Law",
        "Real Estate Law",
        "Tax Law",
    ]
)
num_vars = len(labels)

# Fictional scores for three legal teams
values1 = np.array([4.0, 3.5, 4.6, 4.2, 3.9, 4.8, 4.3, 3.7, 3.4, 4.0, 4.7, 4.3])
values2 = np.array([3.8, 4.2, 4.1, 3.6, 4.0, 3.5, 3.8, 4.5, 4.3, 3.9, 4.1, 3.6])
values3 = np.array([3.5, 3.9, 3.7, 3.2, 3.6, 3.8, 3.9, 4.0, 3.7, 3.5, 3.6, 3.8])

labels2 = ["BrightLaw", "DefenderLegal", "JusticePartners"]
yticks = [1, 2, 3, 4, 5]
ytickslabel = ["1", "2", "3", "4", "5"]
ylim = [0, 5]

title = "Performance Ratings of Legal Teams Across Different Law Domains"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(8, 8), subplot_kw=dict(polar=True))

# Compute angle for each axis
angles = [n / float(num_vars) * 2 * pi for n in range(num_vars)]
values1 = np.concatenate((values1, [values1[0]]))
values2 = np.concatenate((values2, [values2[0]]))
values3 = np.concatenate((values3, [values3[0]]))
angles += angles[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], labels, color="navy", size=10)

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, ytickslabel, color="grey", size=8)
plt.ylim(ylim)

# Plot data
ax.plot(
    angles,
    values1,
    linewidth=2,
    linestyle="solid",
    label=labels2[0],
    color="#1f77b4",
    marker="o",
)
ax.fill(angles, values1, "#1f77b4", alpha=0.25)

ax.plot(
    angles,
    values2,
    linewidth=2,
    linestyle="dashed",
    label=labels2[1],
    color="#ff7f0e",
    marker="s",
)
ax.fill(angles, values2, "#ff7f0e", alpha=0.25)

ax.plot(
    angles,
    values3,
    linewidth=2,
    linestyle="dotted",
    label=labels2[2],
    color="#2ca02c",
    marker="D",
)
ax.fill(angles, values3, "#2ca02c", alpha=0.25)

# Add legend
plt.legend(loc="lower left", bbox_to_anchor=(-0.15, -0.1), fontsize="small")

# Add title
plt.title(title, size=15, color="darkblue", y=1.1)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_40.pdf", bbox_inches="tight")
