
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Data for each religious aspect and respective religion
labels = np.array(
    [
        "Number of\nFollowers",
        "Annual Growth\nRate",
        "Cultural\nInfluence",
        "Historical\nSignificance",
        "Global\nPresence",
    ]
)
stats_religion_a = np.array([85, 70, 90, 60, 75])
stats_religion_b = np.array([65, 80, 75, 85, 50])
stats_religion_c = np.array([70, 95, 60, 80, 65])

# Number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is made circular, so we need to "complete the loop" and append the start to the end.
stats_religion_a = np.concatenate((stats_religion_a, [stats_religion_a[0]]))
stats_religion_b = np.concatenate((stats_religion_b, [stats_religion_b[0]]))
stats_religion_c = np.concatenate((stats_religion_c, [stats_religion_c[0]]))
angles += angles[:1]

# Extracted labels and values
label_religion_a = "Religion A"
label_religion_b = "Religion B"
label_religion_c = "Religion C"
xlim_values = None
ylim_values = (0, 100)
xlabel_value = "Aspects"
ylabel_value = "Values"
xticks_values = angles[:-1]
yticks_values = [20, 40, 60, 80]
xtickslabel_values = labels
ytickslabel_values = []  # Empty list as specified in plt.yticks
title_value = "Comparative Analysis of Religions"
axhline_value = None
axvline_value = None

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the figure
fig, ax = plt.subplots(figsize=(6, 6), subplot_kw=dict(polar=True))

# Draw one axe per variable and add labels with increased padding
plt.xticks(xticks_values, xtickslabel_values, color='darkslateblue')
ax.tick_params(pad=15)  # Increase the distance of the label from the axis

# Draw ylabels and set them to be dashed
ax.set_rlabel_position(0)
plt.yticks(yticks_values, ytickslabel_values, color="grey", size=7)
plt.ylim(ylim_values)

# Customizing the grid (set grid to be dashed)
ax.yaxis.grid(True, linestyle="--", color="grey", linewidth=0.5)

# Plot data with customized styles
ax.plot(
    angles,
    stats_religion_a,
    color="darkorange",
    linewidth=1.5,
    linestyle="solid",
    label=label_religion_a,
)
ax.fill(angles, stats_religion_a, color="darkorange", alpha=0.25)

ax.plot(
    angles,
    stats_religion_b,
    color="teal",
    linewidth=1.5,
    linestyle="dashed",
    label=label_religion_b,
)
ax.fill(angles, stats_religion_b, color="teal", alpha=0.25)

ax.plot(
    angles,
    stats_religion_c,
    color="olive",
    linewidth=1.5,
    linestyle="dotted",
    label=label_religion_c,
)
ax.fill(angles, stats_religion_c, color="olive", alpha=0.25)

# Add title and legend
plt.title(title_value, size=15, color='darkslateblue', y=1.1)
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.3), ncol=3, frameon=False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit
plt.tight_layout()

# Show the plot
plt.savefig("radar_43.pdf", bbox_inches="tight")
