# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
categories = [
    "Healthcare",
    "Economy",
    "Education",
    "Defense",
    "Environment",
    "Infrastructure",
]
values1 = [75, 80, 70, 60, 55, 65]
values2 = [55, 55, 55, 50, 50, 45]
labels = ["Strategy A", "Strategy B"]

# Titles and labels
xlabel = "Policy Areas"
ylabel = "Performance"
title = "Political Strategies Performance in Different Policy Areas"
legendlabels = ["Strategy A", "Strategy B"]
annotate_text1 = [str(val) for val in values1]
annotate_text2 = [str(val) for val in values2]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Number of variables
num_vars = len(categories)

# Compute angle for each category
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is circular, so we need to "complete the loop" and append the start to the end.
values1 += values1[:1]
values2 += values2[:1]
angles += angles[:1]

# Plot
fig, ax = plt.subplots(figsize=(8, 7), subplot_kw=dict(polar=True))
ax.fill(angles, values1, color="#1f77b4", alpha=0.25)  # Dark blue fill
ax.fill(angles, values2, color="#ff7f0e", alpha=0.25)  # Dark red fill
ax.plot(
    angles,
    values1,
    color="#1f77b4",
    linewidth=2,
    linestyle="solid",
    marker="o",
    label=labels[0],
)
ax.plot(
    angles,
    values2,
    color="#ff7f0e",
    linewidth=2,
    linestyle="dashed",
    marker="s",
    label=labels[1],
)

# Labels and annotations for each point
for angle, value1, value2 in zip(angles[:-1], values1[:-1], values2[:-1]):
    ax.annotate(
        f"{value1}", xy=(angle, value1), xytext=(5, 5), textcoords="offset points"
    )
    ax.annotate(
        f"{value2}", xy=(angle, value2), xytext=(5, -15), textcoords="offset points"
    )

# Labels for each point
ax.set_xticks(angles[:-1])
ax.set_xticklabels(categories)

# Remove y-tick labels
ax.set_yticklabels([])

# Legend
ax.legend(
    loc="lower center",
    bbox_to_anchor=(0.5, -0.1),
    ncol=2,
    frameon=True,
    facecolor="#f2f2f2",
    edgecolor="#f2f2f2",
)

# Title
plt.title(title, size=15, color="#333333")

ax.xaxis.set_tick_params(pad=25)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_47.pdf", bbox_inches="tight")
