# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the data for the radar chart
categories = [
    "Education",
    "Healthcare",
    "Employment",
    "Income",
    "Safety",
    "Housing",
    "Environment",
    "Transport",
]
N = len(categories)

# Values for each policy
PolicyA = [75, 85, 65, 70, 90, 80, 60, 85]
PolicyB = [60, 70, 80, 65, 75, 85, 70, 60]
PolicyC = [85, 65, 75, 80, 70, 60, 80, 75]

# Labels and Title
labels = ["Policy A", "Policy B", "Policy C"]
title = "Societal Policies Impact\n(Average scores: 2023)"
yticks = [20, 40, 60, 80, 100]
ylim = [0, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Initialize the spider plot
fig, ax = plt.subplots(figsize=(6, 6), subplot_kw=dict(polar=True))

# We need to repeat the first value to close the circular graph:
PolicyA += PolicyA[:1]
PolicyB += PolicyB[:1]
PolicyC += PolicyC[:1]

# Calculate angle for each category
angles = [n / float(N) * 2 * pi for n in range(N)]
angles += angles[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], categories, color="dimgray", size=10)

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, color="grey", size=8)
plt.ylim(ylim)

# Plot data
ax.plot(
    angles,
    PolicyA,
    linewidth=2,
    linestyle="-",
    marker="o",
    label=labels[0],
    color="#2ca02c",
)
ax.fill(angles, PolicyA, color="#2ca02c", alpha=0.25)

ax.plot(
    angles,
    PolicyB,
    linewidth=2,
    linestyle="--",
    marker="s",
    label=labels[1],
    color="#ff7f0e",
)
ax.fill(angles, PolicyB, color="#ff7f0e", alpha=0.25)

ax.plot(
    angles,
    PolicyC,
    linewidth=2,
    linestyle=":",
    marker="^",
    label=labels[2],
    color="#1f77b4",
)
ax.fill(angles, PolicyC, color="#1f77b4", alpha=0.25)

# Add a title and a legend
plt.title(title, size=15, color="black", y=1.1)
plt.legend(loc="upper right", bbox_to_anchor=(1.15, 1.15))

ax.xaxis.set_tick_params(pad=15)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_49.pdf", bbox_inches="tight")
