
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Define the data for the radar chart
categories = [
    "Reach",
    "Engagement",
    "Sentiment",
    "Shares",
    "Comments",
    "Likes",
    "Views",
]
values1 = [7, 8.5, 6, 7.5, 5, 9, 8]  # Values for Campaign A
values2 = [6, 7, 7, 6, 8, 6.5, 9]   # Values for Campaign B

# Number of variables
N = len(categories)

# Compute angle for each category
angles = [n / float(N) * 2 * pi for n in range(N)]
values1 += values1[:1]
values2 += values2[:1]
angles += angles[:1]

# Extracted variables
line_label1 = "Campaign A"
line_label2 = "Campaign B"
xticks = angles[:-1]
xtickslabel = categories
yticks = [0, 2, 4, 6, 8, 10]
ytickslabel = ["0", "2", "4", "6", "8", "10"]
ylim = (0, 10)
legend_loc = "lower center"
legend_bbox_to_anchor = (0.5, 1.2)
legend_ncol = 2
legend_frameon = False

# Chart title
chart_title = "Media Metrics Comparison"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the spider plot
fig, ax = plt.subplots(figsize=(6, 6), subplot_kw=dict(polar=True))

# Draw one axe per variable and add labels with increased padding
plt.xticks(xticks, xtickslabel, color="black", size=10)
ax.tick_params(pad=20)  # Increase the distance of the label from the axis

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, ytickslabel, color="black", size=7)
plt.ylim(ylim)

# Plot data for Campaign A
ax.plot(
    angles, values1, linewidth=1.5, linestyle="solid", label=line_label1, color="#005f9e"
)
ax.fill(angles, values1, "#005f9e", alpha=0.3)

# Plot data for Campaign B
ax.plot(
    angles, values2, linewidth=1.5, linestyle="--", label=line_label2, color="#8a2be2"
)
ax.fill(angles, values2, "#8a2be2", alpha=0.3)

# Add legend
plt.legend(
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
    frameon=legend_frameon,
)

# Set the background color inside the radar chart to white
ax.set_facecolor("white")

# Add chart title
plt.title(chart_title, size=15, color="black", y=1.1)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit
plt.tight_layout()

# Show the plot
plt.savefig("radar_51.pdf", bbox_inches="tight")
