# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data values
values_urban = [0.8, 0.7, 0.9, 0.6, 0.85]
values_suburban = [0.6, 0.65, 0.7, 0.8, 0.75]
values_rural = [0.4, 0.5, 0.3, 0.7, 0.6]
categories = ["Education", "Health", "Employment", "Housing", "Safety"]
labels = ["Urban", "Suburban", "Rural"]
title = "Quality of Life Indicators Comparison"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialise the radar plot
fig, ax = plt.subplots(figsize=(8, 6), subplot_kw=dict(polar=True))

# Number of variables
N = len(categories)

# What will be the angle of each axis in the plot
angles = [n / float(N) * 2 * np.pi for n in range(N)]
angles += angles[:1]

# Draw one axis per variable and add labels
plt.xticks(angles[:-1], categories, fontsize=12)

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks([0.2, 0.4, 0.6, 0.8], ["0.2", "0.4", "0.6", "0.8"], color="grey", size=7)
plt.ylim(0, 1)

# Plot data
ax.plot(
    angles,
    values_urban + values_urban[:1],
    color="#1f77b4",
    linewidth=1.5,
    linestyle="solid",
    label=labels[0],
    marker="o",
)
ax.fill(angles, values_urban + values_urban[:1], color="#1f77b4", alpha=0.1)

ax.plot(
    angles,
    values_suburban + values_suburban[:1],
    color="#2ca02c",
    linewidth=1.5,
    linestyle="solid",
    label=labels[1],
    marker="s",
)
ax.fill(angles, values_suburban + values_suburban[:1], color="#2ca02c", alpha=0.1)

ax.plot(
    angles,
    values_rural + values_rural[:1],
    color="#d62728",
    linewidth=1.5,
    linestyle="solid",
    label=labels[2],
    marker="d",
)
ax.fill(angles, values_rural + values_rural[:1], color="#d62728", alpha=0.1)


# Add legend
plt.legend(loc="upper left", bbox_to_anchor=(1, 1), fontsize=10)
ax.xaxis.set_tick_params(pad=20)

# Add title
plt.title(title, size=15, y=1.1)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_54.pdf", bbox_inches="tight")
