# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data values
values_residential = [0.65, 0.7, 0.55, 0.6, 0.68]
values_commercial = [0.75, 0.75, 0.6, 0.65, 0.72]
values_industrial = [0.5, 0.65, 0.5, 0.55, 0.58]
categories = ["Residential", "Commercial", "Industrial", "Transportation", "Renewable"]
labels = ["Region A", "Region B", "Region C"]

# Text labels
title = "Energy Consumption Across Sectors"
legendlabels = labels

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialise the radar plot
fig, ax = plt.subplots(figsize=(8, 6), subplot_kw=dict(polar=True))

# Number of variables
N = len(categories)

# What will be the angle of each axis in the plot
angles = [n / float(N) * 2 * np.pi for n in range(N)]
angles += angles[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], categories)

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks([0.2, 0.4, 0.6, 0.8], [], color="grey", size=7)
plt.ylim(0, 1)

# Plot data
ax.plot(
    angles,
    values_residential + values_residential[:1],
    color="seagreen",
    linewidth=2,
    linestyle="dashdot",
    label=labels[0],
    marker="o",
)
ax.fill(
    angles, values_residential + values_residential[:1], color="seagreen", alpha=0.25
)

ax.plot(
    angles,
    values_commercial + values_commercial[:1],
    color="steelblue",
    linewidth=2,
    linestyle="dashdot",
    label=labels[1],
    marker="s",
)
ax.fill(
    angles, values_commercial + values_commercial[:1], color="steelblue", alpha=0.25
)

ax.plot(
    angles,
    values_industrial + values_industrial[:1],
    color="mediumvioletred",
    linewidth=2,
    linestyle="dashdot",
    label=labels[2],
    marker="^",
)
ax.fill(
    angles,
    values_industrial + values_industrial[:1],
    color="mediumvioletred",
    alpha=0.25,
)

# Add legend
plt.legend(loc="upper left", bbox_to_anchor=(1, 1))

# Add title
plt.title(title, size=16, color="darkslategray")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_56.pdf", bbox_inches="tight")
