
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the radar chart
labels = np.array(
    [
        "Clarity",
        "Brevity",
        "Engagement",
        "Listening",
        "Non-verbal Cues",
        "Confidence",
        "Empathy",
        "Feedback",
    ]
)
stats_model_a = np.random.rand(8)
stats_model_b = np.random.rand(8)
xticks = [0.2, 0.4, 0.6, 0.8]
xtickslabel = ["0.2", "0.4", "0.6", "0.8"]
label_a = "Model A"
label_b = "Model B"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(6, 6), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is circular, so we need to "complete the loop" and append the start to the end.
stats_model_a = np.concatenate((stats_model_a, [stats_model_a[0]]))
stats_model_b = np.concatenate((stats_model_b, [stats_model_b[0]]))
angles += angles[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], labels, color="black", size=10)
ax.tick_params(pad=20)  # Increase the distance of the label from the axis

# Draw ylabels
ax.set_rscale("linear")
plt.yticks(xticks, xtickslabel, color="grey", size=7)
plt.ylim(0, 1)

# Plot data for Model A
ax.plot(
    angles,
    stats_model_a,
    linewidth=2,
    linestyle="solid",
    label=label_a,
    marker="o",
    color="#1f78b4",
)
# Plot data for Model B
ax.plot(
    angles,
    stats_model_b,
    linewidth=2,
    linestyle="--",
    label=label_b,
    marker="s",
    color="#33a02c",
)

# Add legend
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.2), ncol=2)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_57.pdf", bbox_inches="tight")

