# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for each region
labels = np.array(
    [
        "GDP Growth",
        "Population Growth",
        "Healthcare",
        "Education",
        "Infrastructure",
        "Environment",
        "Technology",
        "Quality of Life",
    ]
)
North_America = np.array([0.85, 0.55, 0.9, 0.88, 0.8, 0.72, 0.87, 0.9])
Europe = np.array([0.8, 0.4, 0.93, 0.92, 0.83, 0.77, 0.85, 0.9])
Asia = np.array([0.95, 0.8, 0.7, 0.65, 0.75, 0.68, 0.91, 0.88])
Africa = np.array([0.75, 0.95, 0.55, 0.6, 0.65, 0.7, 0.6, 0.58])
yticks = [0.2, 0.4, 0.6, 0.8]
labels2 = ["North America", "Europe", "Asia", "Africa"]
title = "Geographical Region Comparison Based on Various Attributes"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(6, 6), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is made circular, so we need to complete the loop
North_America = np.concatenate((North_America, [North_America[0]]))
Europe = np.concatenate((Europe, [Europe[0]]))
Asia = np.concatenate((Asia, [Asia[0]]))
Africa = np.concatenate((Africa, [Africa[0]]))
angles += angles[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], labels, color="black", size=10)
ax.tick_params(pad=10)  # Increase the distance of the label from the axis

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, [], color="grey", size=7)
plt.ylim(0, 1)

# Plot data
ax.plot(
    angles,
    North_America,
    color="#1f77b4",
    linewidth=2,
    linestyle="solid",
    label=labels2[0],
    marker="o",
)
ax.plot(
    angles,
    Europe,
    color="#ff7f0e",
    linewidth=2,
    linestyle="dashdot",
    label=labels2[1],
    marker="s",
)
ax.plot(
    angles,
    Asia,
    color="#2ca02c",
    linewidth=2,
    linestyle="dashed",
    label=labels2[2],
    marker="^",
)
ax.plot(
    angles,
    Africa,
    color="#d62728",
    linewidth=2,
    linestyle="dotted",
    label=labels2[3],
    marker="D",
)

# Add legend
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.3), ncol=4)

ax.xaxis.set_tick_params(pad=25)

# Chart title
plt.title(title, size=15, color="#333")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_62.pdf", bbox_inches="tight")
