# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from math import pi
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
np.random.seed(0)

# Define the data for each mode of transportation
values1 = [90, 90, 90, 80, 80]  # Car
values2 = [79, 78, 76, 70, 70]  # Bus
values3 = [68, 60, 66, 61, 76]  # Bicycle
values4 = [54, 41, 51, 53, 56]  # Train
values5 = [33, 34, 33, 30, 20]  # Airplane

xtickslabel = ["City Center", "Suburbs", "Rural Areas", "Airports", "Highways"]
yticks = [20, 40, 60, 80, 100]
ytickslabel = ["20", "40", "60", "80", "100"]
ylim = [0, 100]
labels = ["Car", "Bus", "Bicycle", "Train", "Airplane"]

# Number of variables
num_vars = len(values1)

# Compute angle for each axis
angles = [n / float(num_vars) * 2 * pi for n in range(num_vars)]
angles += angles[:1]  # Complete the loop

# Repeat the first value to close the circle
values1 += values1[:1]
values2 += values2[:1]
values3 += values3[:1]
values4 += values4[:1]
values5 += values5[:1]

title = "Transportation Mode Usage by Location"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the spider plot
fig, ax = plt.subplots(figsize=(8, 7), subplot_kw=dict(polar=True))

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], xtickslabel, size=10)

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, ytickslabel, color="grey", size=7)
plt.ylim(ylim)

# Plot each mode of transportation
color_scheme = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]
line_styles = ["solid", "dashed", "dotted", "dashdot", "solid"]
markers = ["o", "s", "^", "D", "v"]

ax.plot(
    angles,
    values1,
    linewidth=2,
    linestyle=line_styles[0],
    label=labels[0],
    color=color_scheme[0],
    marker=markers[0],
)
ax.fill(angles, values1, color_scheme[0], alpha=0.1)

ax.plot(
    angles,
    values2,
    linewidth=2,
    linestyle=line_styles[1],
    label=labels[1],
    color=color_scheme[1],
    marker=markers[1],
)
ax.fill(angles, values2, color_scheme[1], alpha=0.1)

ax.plot(
    angles,
    values3,
    linewidth=2,
    linestyle=line_styles[2],
    label=labels[2],
    color=color_scheme[2],
    marker=markers[2],
)
ax.fill(angles, values3, color_scheme[2], alpha=0.1)

ax.plot(
    angles,
    values4,
    linewidth=2,
    linestyle=line_styles[3],
    label=labels[3],
    color=color_scheme[3],
    marker=markers[3],
)
ax.fill(angles, values4, color_scheme[3], alpha=0.1)

ax.plot(
    angles,
    values5,
    linewidth=2,
    linestyle=line_styles[4],
    label=labels[4],
    color=color_scheme[4],
    marker=markers[4],
)
ax.fill(angles, values5, color_scheme[4], alpha=0.1)

# Add data points labels
for i in range(num_vars):
    # For Car values
    ax.annotate(
        f"{values1[i]}",
        xy=(angles[i], values1[i]),
        xytext=(5, 5),
        textcoords="offset points",
        ha="right",
        va="bottom",
        size=8,
        color=color_scheme[0],
    )
    # For Bus values
    ax.annotate(
        f"{values2[i]}",
        xy=(angles[i], values2[i]),
        xytext=(5, 5),
        textcoords="offset points",
        ha="right",
        va="bottom",
        size=8,
        color=color_scheme[1],
    )
    # For Bicycle values
    ax.annotate(
        f"{values3[i]}",
        xy=(angles[i], values3[i]),
        xytext=(5, 5),
        textcoords="offset points",
        ha="right",
        va="bottom",
        size=8,
        color=color_scheme[2],
    )
    # For Train values
    ax.annotate(
        f"{values4[i]}",
        xy=(angles[i], values4[i]),
        xytext=(5, 5),
        textcoords="offset points",
        ha="right",
        va="bottom",
        size=8,
        color=color_scheme[3],
    )
    # For Airplane values
    ax.annotate(
        f"{values5[i]}",
        xy=(angles[i], values5[i]),
        xytext=(5, 5),
        textcoords="offset points",
        ha="right",
        va="bottom",
        size=8,
        color=color_scheme[4],
    )

# Add a legend to the upper right
plt.legend(loc="upper right", bbox_to_anchor=(1.15, 1.15))

# Add title
plt.title(title, size=15, color="navy")

# ===================
# Part 4: Saving Output
# ===================
# Adjust figure size to match original image's dimensions
fig.set_size_inches(8, 7)

# Adjust layout
plt.tight_layout()

plt.savefig("radar_68.pdf", bbox_inches="tight")
