
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Define the new data for each marketing strategy
labels = np.array(
    ["Reach", "Engagement", "Cost Efficiency", "Conversion Rate", "Customer Retention"]
)
stats = np.array(
    [
        [5, 4, 3, 4, 5],  # Digital Marketing
        [3, 2, 4, 3, 4],  # Print Advertising
        [4, 5, 2, 5, 3],  # Social Media Campaigns
    ]
)
titles = ["Digital Marketing", "Print Advertising", "Social Media Campaigns"]
rticks = [1, 2, 3, 4, 5]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, ax = plt.subplots(figsize=(12, 8), nrows=1, ncols=3, subplot_kw=dict(polar=True))
# Define the number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is made circular
stats = np.concatenate((stats, stats[:, [0]]), axis=1)
angles += angles[:1]
# Define colors
colors = ["#FF6F61", "#6B5B95", "#88B04B"]

# Draw one radar chart for each marketing strategy
for idx, (title, case_data) in enumerate(zip(titles, stats)):
    ax[idx].fill(angles, case_data, color=colors[idx], alpha=0.25)
    ax[idx].plot(angles, case_data, color=colors[idx], linewidth=2, linestyle='--', marker='o')
    ax[idx].set_rticks(rticks)
    ax[idx].set_xticks(angles[:-1])
    ax[idx].set_xticklabels(labels)
    ax[idx].set_title(title, color=colors[idx])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit
plt.tight_layout(rect=[0, 0.03, 1, 0.95])

plt.savefig("radar_71.pdf", bbox_inches="tight")
