# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
crops = [
    "Wheat",
    "Corn",
    "Rice",
    "Soybean",
    "Potato",
    "Tomato",
    "Carrot",
    "Lettuce",
    "Broccoli",
]
values = {
    "Growth Rate": [1.8, 2.0, 1.6, 1.9, 1.5, 1.7, 1.3, 1.4, 1.8],
    "Water Requirement": [0.9, 1.1, 1.2, 1.0, 0.8, 1.3, 0.7, 0.6, 1.0],
    "Yield": [1.4, 1.9, 1.7, 1.8, 1.5, 1.6, 1.2, 1.3, 1.5],
    "Disease Resistance": [0.8, 1.0, 0.9, 1.1, 0.7, 0.8, 1.3, 1.2, 1.0],
    "Nutrient Efficiency": [1.5, 1.8, 1.6, 1.4, 1.2, 1.7, 1.3, 1.1, 1.5],
    "Market Value": [1.6, 1.9, 1.8, 1.5, 1.3, 1.7, 1.2, 1.1, 1.4],
}

# Plot labels
xlabel = "Value"
title = "Agricultural Crop Characteristics"
suptitle = "Comparison of Various Agricultural Crops"
legendlabels = list(values.keys())

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#2E8B57", "#8B4513", "#556B2F", "#FFD700", "#8B0000", "#4682B4"]
markers = ["o", "s", "D", "^", "v", "*"]

# Create subplots
fig, axes = plt.subplots(1, 6, figsize=(15, 5), sharey=True)

# Plot each category
for ax, (category, color, marker) in zip(axes, zip(values.keys(), colors, markers)):
    ax.scatter(values[category], crops, color=color, marker=marker)
    ax.set_title(category)
    ax.set_xlim(0, 2)
    ax.axvline(x=1, color="black", linestyle="--", linewidth=1)

# Set common labels
fig.text(0.5, 0.04, xlabel, ha="center", va="center")
fig.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout(rect=[0.03, 0.05, 1, 0.95])
plt.savefig("scatter_26.pdf", bbox_inches="tight")
