
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
models = [
    "gpt-law-1",
    "lex-davinci-003",
    "lex-davinci-002",
    "legal-claude-1",
    "legal-claude-2",
    "legal-bison@002",
    "hf_juris-40b",
    "law-llama-2-70",
    "law-llama-2-70-chat",
]
values = {
    "Legal Research": [1.8, 1.6, 1.7, 1.5, 1.9, 1.4, 1.8, 1.3, 1.5],
    "Case Analysis": [1.0, 0.8, 0.9, 0.7, 1.1, 0.6, 1.2, 0.5, 0.4],
    "Argumentation": [1.5, 1.7, 1.6, 1.8, 1.4, 1.9, 1.3, 1.1, 1.2],
    "Precedent Application": [1.9, 1.5, 1.8, 1.4, 2.0, 1.3, 1.6, 1.2, 1.1],
    "Decision Complexity": [1.2, 1.4, 1.3, 1.5, 1.1, 1.6, 1.7, 1.9, 1.8],
    "Compliance Checking": [1.0, 0.9, 1.1, 0.8, 1.2, 0.7, 1.3, 0.6, 0.5],
}

# Axis labels and other text
xlabel = "Performance Value"
title = "AI Legal Models Performance Comparison"
labels = list(values.keys())
colors = ["#4E79A7", "#F28E2B", "#E15759", "#76B7B2", "#59A14F", "#EDC948"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Create subplots
fig, axes = plt.subplots(1, 6, figsize=(15, 6), sharey=True)

# Plot each category
for ax, (category, color) in zip(axes, zip(values.keys(), colors)):
    ax.scatter(values[category], models, color=color, edgecolor='black', s=100, alpha=0.75)
    ax.set_title(category, fontsize=10)
    ax.set_xlim(0, 2)
    ax.axvline(x=1, color="grey", linestyle="--", linewidth=1)

# Set common labels and title
fig.text(0.5, 0.04, xlabel, ha='center', va='center', fontsize=12)
fig.suptitle(title, fontsize=14)

# Improve layout
plt.tight_layout(rect=[0.03, 0.06, 1, 0.95])

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("scatter_28.pdf", bbox_inches="tight")
