# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
years = [2010, 2015, 2020]

# Party A
support_a = [30, 35, 40]
sizes_a = [200, 300, 400]

# Party B
support_b = [20, 45, 25]
sizes_b = [250, 400, 150]

# Party C
support_c = [50, 35, 30]
sizes_c = [300, 250, 200]

# Labels and titles
legend_labels = ["Party A", "Party B", "Party C"]
title = "Political Support Trends"
xlabel = "Year"
ylabel = "Support (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 6))

# Scatter points with unique colors and markers
party_a_scatter = ax.scatter(years, support_a, s=sizes_a, alpha=0.8, color="#1f77b4")
party_b_scatter = ax.scatter(years, support_b, s=sizes_b, alpha=0.8, color="#ff7f0e")
party_c_scatter = ax.scatter(years, support_c, s=sizes_c, alpha=0.8, color="#2ca02c")

# Connect points with customized lines
ax.plot(years, support_a, linestyle="--", color="#1f77b4", alpha=0.8, linewidth=2)
ax.plot(years, support_b, linestyle="-.", color="#ff7f0e", alpha=0.8, linewidth=2)
ax.plot(years, support_c, linestyle=":", color="#2ca02c", alpha=0.8, linewidth=2)

# Legend
legend = ax.legend(
    [party_a_scatter, party_b_scatter, party_c_scatter],
    legend_labels,
    title="Parties",
    loc="best",
)

for legend_handle in legend.legendHandles:
    legend_handle._sizes = [80]  # 设置图例标记的大小

legend.get_frame().set_alpha(1)  # Make legend background opaque

# Axes labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Title of the plot
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("scatter_30.pdf", bbox_inches="tight")
