
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Sample data for the plot; replace with actual data.
methods = ["CBT", "DBT", "EMDR", "Mindfulness", "Psychodynamic", "Humanistic"]

# Data for the subplots; each list within diversity_data and accuracy_data corresponds to a subplot.
diversity_data = [[0.5, 0.8, 1.1, 0.9, 1.2, 0.7], [1.5, 2.1, 1.8, 2.3, 2.5, 2.8]]

accuracy_data = [[70, 65, 80, 75, 85, 90], [60, 70, 85, 78, 90, 88]]

# Sizes for the scatter points, shared across both subplots.
scatter_sizes = [60, 90, 120, 150, 200, 250]

# Legend labels for the subplots.
ax1_legend_names = ["1 year", "5 years", "10 years", "15 years"]
ax2_legend_names = ["10 sessions", "20 sessions", "30 sessions", "40 sessions"]
ax1_legend_title = "Study Duration"
ax2_legend_title = "Number of Sessions"
xlabel = "Diversity of Techniques"
ylabel = "Effectiveness (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create 2x1 grid of subplots with a specified figure size.
fig, axs = plt.subplots(2, 1, figsize=(8, 8))

colors = [
    "#2E91E5",
    "#E15F99",
    "#1CA71C",
    "#FB0D0D",
    "#DA16FF",
    "#222A2A",
]  # Custom colors for each method.

# Populate the subplots with scatter points and add text labels.
for idx, ax in enumerate(axs):
    for method, div, acc, size, color in zip(
        methods, diversity_data[idx], accuracy_data[idx], scatter_sizes, colors
    ):
        ax.scatter(div, acc, s=size, color=color, alpha=0.6, edgecolor='w', linewidth=0.5)  # Plot the scatter points.
        ax.text(
            div, acc + 3, method, fontsize=10, ha='center'
        )  # Add text labels above scatter points.

    ax.set_xlabel(xlabel)  # X-axis label.
    ax.set_ylabel(ylabel)  # Y-axis label.

# Adjust the x and y limits and ticks for the subplots.
axs[0].set_xlim(0.3, 1.4)
axs[0].set_ylim(60, 95)
axs[0].set_xticks([0.4, 0.6, 0.8, 1.0, 1.2])
axs[0].set_yticks([60, 70, 80, 90])
axs[1].set_xlim(1.4, 3.0)
axs[1].set_ylim(55, 95)
axs[1].set_xticks([1.5, 2.0, 2.5, 3.0])
axs[1].set_yticks([60, 70, 80, 90])

size_legend_handles = [60, 90, 150, 250]  # Sizes for the legend handles.

# Create custom legend handles for the first subplot.
ax1_legend_handles = [
    mlines.Line2D(
        [],
        [],
        color="#8080f7",
        marker="o",
        linestyle="None",
        markersize=(size**0.5) * 0.8,
        label=name,
    )  # Adjust marker size here.
    for size, name in zip(size_legend_handles, ax1_legend_names)
]

# Create custom legend handles for the second subplot.
ax2_legend_handles = [
    mlines.Line2D(
        [],
        [],
        color="#8080f7",
        marker="o",
        linestyle="None",
        markersize=(size**0.5) * 0.8,
        label=name,
    )  # Adjust marker size here.
    for size, name in zip(size_legend_handles, ax2_legend_names)
]

# Add legends to the subplots.
axs[0].legend(
    handles=ax1_legend_handles,
    loc="lower right",
    title=ax1_legend_title,
    labelspacing=2.0,
    edgecolor="black",
)
axs[1].legend(
    handles=ax2_legend_handles,
    loc="lower right",
    title=ax2_legend_title,
    labelspacing=2.0,
    edgecolor="black",
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("scatter_32.pdf", bbox_inches="tight")
