# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Sample data for the plot; replace with actual data.
methods = [
    "Lectures",
    "Group Study",
    "Projects",
    "Online Courses",
    "Tutoring",
    "Self-Study",
]

# Data for the subplots; each list within engagement_data and improvement_data corresponds to a subplot.
engagement_data = [[3.1, 4.2, 2.7, 3.0, 4.5, 2.8], [3.8, 5.1, 5.7, 4.9, 4.6, 4.3]]
improvement_data = [[60, 55, 45, 75, 70, 65], [50, 60, 85, 80, 75, 78]]

# Sizes for the scatter points, shared across both subplots.
scatter_sizes = [50, 100, 100, 175, 300, 300]

# Legend labels for the subplots.
ax1_legend_names = ["Low", "Moderate", "High", "Very High"]
ax2_legend_names = ["50 hours", "100 hours", "200 hours", "400 hours"]
ax1_legend_title = "Engagement Level"
ax2_legend_title = "Study Hours"
xlabel = "Student Engagement"
ylabel = "Grades Improvement (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create 2x1 grid of subplots with a specified figure size.
fig, axs = plt.subplots(2, 1, figsize=(6, 6))

colors = [
    "#1f77b4",  # blue
    "#ff7f0e",  # orange
    "#2ca02c",  # green
    "#d62728",  # red
    "#9467bd",  # purple
    "#8c564b",  # brown
]  # Colors for each method.

# Populate the subplots with scatter points and add text labels.
for idx, ax in enumerate(axs):
    for method, eng, imp, size, color in zip(
        methods, engagement_data[idx], improvement_data[idx], scatter_sizes, colors
    ):
        ax.scatter(eng, imp, s=size, color=color, alpha=0.6)  # Plot the scatter points.
        ax.text(
            eng, imp + 2, method, fontsize=9
        )  # Add text labels above scatter points.

    ax.set_xlabel(xlabel)  # X-axis label.
    ax.set_ylabel(ylabel)  # Y-axis label.

# Adjust the x and y limits and ticks for the subplots.
axs[0].set_xlim(2.6, 5.2)
axs[0].set_ylim(40, 80)
axs[0].set_xticks(np.arange(2.6, 5.3, 0.5))
axs[0].set_yticks(np.arange(40, 81, 10))
axs[1].set_xlim(3.5, 6.5)
axs[1].set_ylim(40, 90)
axs[1].set_xticks(np.arange(4.0, 6.6, 0.5))
axs[1].set_yticks(np.arange(40, 91, 10))

size_legend_handles = [50, 100, 175, 250]  # Sizes for the legend handles.

# Create custom legend handles for the first subplot.
ax1_legend_handles = [
    mlines.Line2D(
        [],
        [],
        color="#8080f7",
        marker="o",
        linestyle="None",
        markersize=(size**0.5) * 0.8,
        label=name,
    )  # Adjust marker size here.
    for size, name in zip(size_legend_handles, ax1_legend_names)
]

# Create custom legend handles for the second subplot.
ax2_legend_handles = [
    mlines.Line2D(
        [],
        [],
        color="#8080f7",
        marker="o",
        linestyle="None",
        markersize=(size**0.5) * 0.8,
        label=name,
    )  # Adjust marker size here.
    for size, name in zip(size_legend_handles, ax2_legend_names)
]

# Add legends to the subplots.
axs[0].legend(
    handles=ax1_legend_handles,
    loc="lower right",
    title=ax1_legend_title,
    labelspacing=2.0,
    edgecolor="black",
)
axs[1].legend(
    handles=ax2_legend_handles,
    loc="lower right",
    title=ax2_legend_title,
    labelspacing=2.0,
    edgecolor="black",
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("scatter_34.pdf", bbox_inches="tight")
