
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

clusters = {
    "cluster_1": np.random.multivariate_normal([50, 5], [[10, 2], [2, 1]], 20),
    "cluster_2": np.random.multivariate_normal([70, 15], [[10, 2], [2, 1]], 20),
    "cluster_3": np.random.multivariate_normal([90, 25], [[10, 2], [2, 1]], 20),
    "cluster_4": np.random.multivariate_normal([50, 25], [[10, 2], [2, 1]], 20),
    "cluster_5": np.random.multivariate_normal([90, 5], [[10, 2], [2, 1]], 20),
    "cluster_6": np.random.multivariate_normal([70, 10], [[15, 3], [3, 2]], 20),
}

# Variables for plot configuration
xlim = [30, 110]
ylim = [0, 30]
xlabel = "Test Scores"
ylabel = "Study Hours"
xticks = np.arange(30, 111, 10)
yticks = np.arange(0, 31, 5)
xtickslabel = xticks.astype(str)
ytickslabel = yticks.astype(str)
title = "Student Performance Clusters in a School"
legendlabels = ["Low Scores, Low Study Hours", "Medium Scores, Medium Study Hours", "High Scores, High Study Hours",
            "Low Scores, High Study Hours", "High Scores, Low Study Hours", "Mixed Performance"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the scatter plot
plt.figure(figsize=(10, 7))

# Colors for each cluster
colors = {
    "cluster_1": "#D55E00",
    "cluster_2": "#009E73",
    "cluster_3": "#0072B2",
    "cluster_4": "#F0E442",
    "cluster_5": "#CC79A7",
    "cluster_6": "#56B4E9",
}

markers = {
    "cluster_1": "o",
    "cluster_2": "s",
    "cluster_3": "d",
    "cluster_4": "^",
    "cluster_5": "v",
    "cluster_6": "<",
}

for cluster, data in clusters.items():
    plt.scatter(data[:, 0], data[:, 1], c=colors[cluster], alpha=0.6, edgecolors='w', s=100, label=legendlabels.pop(0), marker=markers[cluster])

# Applying configurations
plt.xlim(xlim)
plt.ylim(ylim)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.xticks(xticks, xtickslabel)
plt.yticks(yticks, ytickslabel)
plt.title(title)
plt.legend(loc="best")
plt.grid(True, linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_37.pdf", bbox_inches="tight")
